/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nrtc.rec;

import com.netease.nrtc.trace.OrcTrace;
import java.util.concurrent.locks.ReentrantLock;

class RecEngineNative {
    private int ref_count = 0;
    private ReentrantLock lock = new ReentrantLock();
    long nativeRecEngine;

    RecEngineNative() {
    }

    void releaseRef() {
        try {
            this.lock.lock();
            if (--this.ref_count == 0) {
                long l2 = System.currentTimeMillis();
                this.dispose_();
                this.nativeRecEngine = 0L;
                long l3 = System.currentTimeMillis() - l2;
                OrcTrace.info("RecEngineNative", "dispose rec engine:" + l3);
            } else if (this.ref_count < 0) {
                this.ref_count = 0;
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean acquireRef() {
        try {
            this.lock.lock();
            if (++this.ref_count == 1) {
                --this.ref_count;
                return false;
            }
            return this.ref_count > 1;
            {
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean acquireRefWithCreate(String string) {
        try {
            this.lock.lock();
            if (++this.ref_count == 1) {
                OrcTrace.info("RecEngineNative", "create rec engine...");
                this.nativeRecEngine = this.create_(string);
                OrcTrace.info("RecEngineNative", "create rec engine ->" + this.nativeRecEngine);
                if (this.nativeRecEngine == 0L) {
                    --this.ref_count;
                    return false;
                }
                return true;
            }
            return this.ref_count > 1;
            {
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private long create_(String string) {
        OrcTrace.a();
        return this.create(string);
    }

    private void dispose_() {
        this.dispose();
        OrcTrace.b();
    }

    native long create(String var1);

    native void dispose();
}

