/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nrtc.video;

import com.netease.nrtc.trace.OrcTrace;
import java.util.concurrent.locks.ReentrantLock;

public class VideoEngineNative {
    private int ref_count = 0;
    private ReentrantLock lock = new ReentrantLock();
    private long nativeVideoEngine;

    public void releaseRef() {
        try {
            this.lock.lock();
            if (--this.ref_count == 0) {
                long l2 = System.currentTimeMillis();
                this.dispose_();
                this.nativeVideoEngine = 0L;
                long l3 = System.currentTimeMillis() - l2;
                OrcTrace.info("VideoEngineNativeNew", "dispose video engine:" + l3);
            } else if (this.ref_count < 0) {
                this.ref_count = 0;
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean acquireRef(boolean bl) {
        try {
            this.lock.lock();
            if (++this.ref_count == 1) {
                if (bl) {
                    OrcTrace.info("VideoEngineNativeNew", "create video engine");
                    this.nativeVideoEngine = this.create_();
                    if (this.nativeVideoEngine != 0L) {
                        return true;
                    }
                }
                --this.ref_count;
                OrcTrace.error("VideoEngineNativeNew", "acquire video engine failed");
                return false;
            }
            if (this.ref_count > 1) {
                return true;
            }
            OrcTrace.error("VideoEngineNativeNew", "acquire video engine failed");
            return false;
        }
        finally {
            this.lock.unlock();
        }
    }

    private long create_() {
        OrcTrace.a();
        OrcTrace.info("VideoEngineNativeNew", "video engine create");
        return this.create();
    }

    private void dispose_() {
        this.dispose();
        OrcTrace.info("VideoEngineNativeNew", "video engine dispose");
        OrcTrace.b();
    }

    private native long create();

    private native void dispose();

    public native int init(boolean var1);

    native int remoteFrameToRender(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6, int var7, long var8);

    native int localFrameToRender(byte[] var1, int var2, int var3, int var4, int var5, boolean var6, byte[] var7);

    native void localFrameToSend(byte[] var1, int var2, int var3, int var4, int var5, boolean var6, byte[] var7, int var8, int var9, int var10, long var11, int[] var13);

    native void registerSendCodec(int var1, int var2, int var3, float var4, int var5, int var6, int var7, String var8);

    native void registerReceiveCodec(int var1);

    native void setSendRate(int var1, int var2);

    native int forceIntraFrame();

    native void setRecTransport(long var1);
}

