/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nrtc.video2;

import com.netease.nrtc.trace.OrcTrace;
import java.util.concurrent.locks.ReentrantLock;

public class VideoNative {
    private int ref_count = 0;
    private ReentrantLock lock = new ReentrantLock();
    private long nativeVideoEngine;

    public void releaseRef() {
        try {
            this.lock.lock();
            if (--this.ref_count == 0) {
                long l2 = System.currentTimeMillis();
                this.dispose_();
                this.nativeVideoEngine = 0L;
                long l3 = System.currentTimeMillis() - l2;
                OrcTrace.info("VideoNative2", "dispose video engine:" + l3);
            } else if (this.ref_count < 0) {
                this.ref_count = 0;
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean acquireRef(boolean bl) {
        try {
            this.lock.lock();
            if (++this.ref_count == 1) {
                if (bl) {
                    OrcTrace.info("VideoNative2", "create video engine");
                    this.nativeVideoEngine = this.create_();
                    if (this.nativeVideoEngine != 0L) {
                        return true;
                    }
                }
                --this.ref_count;
                OrcTrace.error("VideoNative2", "acquire video engine failed");
                return false;
            }
            if (this.ref_count > 1) {
                return true;
            }
            OrcTrace.error("VideoNative2", "acquire video engine failed");
            return false;
        }
        finally {
            this.lock.unlock();
        }
    }

    private long create_() {
        OrcTrace.a();
        OrcTrace.info("VideoNative2", "video engine create");
        return this.create();
    }

    private void dispose_() {
        this.dispose();
        OrcTrace.info("VideoNative2", "video engine dispose");
        OrcTrace.b();
    }

    private native long create();

    private native void dispose();

    public native void registerSendCodec(int var1, int var2, int var3, float var4, int var5, int var6, int var7, String var8);

    public native void registerReceiveCodec(int var1);

    public native int setBitrate(int var1);

    public native int setMaxBitrate(int var1);

    public native int setFramerate(int var1);

    public native int requestKeyFrame();

    public native void setRecTransport(long var1);

    public native int localFrameProcess(byte[] var1, int var2, int var3, long var4, int var6, int var7, int var8, boolean var9, int var10, int var11, byte[] var12, byte[] var13, int[] var14);

    public native int rotateAndCropFrame(byte[] var1, int var2, int var3, int var4, int var5, int var6, int var7, byte[] var8, int var9);

    public native int remoteFrameProcess(byte[] var1, int var2, int var3, int[] var4, byte[] var5, byte[] var6, int var7);
}

