/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import java.util.Map;

public interface Id {
    public String name();

    public Iterable<Tag> tags();

    public Id withTag(String var1, String var2);

    public Id withTag(Tag var1);

    default public Id withTag(String k, boolean v) {
        return this.withTag(k, Boolean.toString(v));
    }

    default public <E extends Enum<E>> Id withTag(String k, Enum<E> v) {
        return this.withTag(k, v.name());
    }

    default public Id withTags(String k1, String v1) {
        return this.withTag(k1, v1);
    }

    default public Id withTags(String k1, String v1, String k2, String v2) {
        Tag[] ts = new Tag[]{new BasicTag(k1, v1), new BasicTag(k2, v2)};
        return this.withTags(ts);
    }

    default public Id withTags(String k1, String v1, String k2, String v2, String k3, String v3) {
        Tag[] ts = new Tag[]{new BasicTag(k1, v1), new BasicTag(k2, v2), new BasicTag(k3, v3)};
        return this.withTags(ts);
    }

    default public Id withTags(String ... tags) {
        Id tmp = this;
        for (int i = 0; i < tags.length; i += 2) {
            tmp = tmp.withTag(tags[i], tags[i + 1]);
        }
        return tmp;
    }

    default public Id withTags(Tag ... tags) {
        Id tmp = this;
        for (Tag t : tags) {
            tmp = tmp.withTag(t);
        }
        return tmp;
    }

    default public Id withTags(Iterable<Tag> tags) {
        Id tmp = this;
        for (Tag t : tags) {
            tmp = tmp.withTag(t);
        }
        return tmp;
    }

    default public Id withTags(Map<String, String> tags) {
        Id tmp = this;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            tmp = tmp.withTag(entry.getKey(), entry.getValue());
        }
        return tmp;
    }
}

