/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.exceptions;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.ErrorDetails;
import com.paypal.sdk.models.LinkDescription;
import io.apimatic.coreinterfaces.http.Context;
import java.util.List;

/**
 * This is a model class for ErrorException type.
 */
public class ErrorException extends ApiException {
    private static final long serialVersionUID = 6116964831270098469L;
    private String name;
    private String message;
    private String debugId;
    private List<ErrorDetails> details;
    private List<LinkDescription> links;

    /**
     * Initialization constructor.
     * @param   reason  The reason for throwing exception
     * @param   context The context of the API exception
     */
    public ErrorException(String reason, Context context) {
        super(reason, context);
    }


    /**
     * Getter for Name.
     * The human-readable, unique name of the error.
     * @return Returns the String
     */
    @JsonGetter("name")
    public String getName() {
        return this.name;
    }

    /**
     * Setter for Name.
     * The human-readable, unique name of the error.
     * @param name Value for String
     */
    @JsonSetter("name")
    private void setName(String name) {
        this.name = name;
    }

    /**
     * Getter for Message.
     * The message that describes the error.
     * @return Returns the String
     */
    @JsonGetter("message")
    public String getMessageField() {
        return this.message;
    }

    /**
     * Setter for Message.
     * The message that describes the error.
     * @param messageField Value for String
     */
    @JsonSetter("message")
    private void setMessageField(String messageField) {
        this.message = messageField;
    }

    /**
     * Getter for DebugId.
     * The PayPal internal ID. Used for correlation purposes.
     * @return Returns the String
     */
    @JsonGetter("debug_id")
    public String getDebugId() {
        return this.debugId;
    }

    /**
     * Setter for DebugId.
     * The PayPal internal ID. Used for correlation purposes.
     * @param debugId Value for String
     */
    @JsonSetter("debug_id")
    private void setDebugId(String debugId) {
        this.debugId = debugId;
    }

    /**
     * Getter for Details.
     * An array of additional details about the error.
     * @return Returns the List of ErrorDetails
     */
    @JsonGetter("details")
    public List<ErrorDetails> getDetails() {
        return this.details;
    }

    /**
     * Setter for Details.
     * An array of additional details about the error.
     * @param details Value for List of ErrorDetails
     */
    @JsonSetter("details")
    private void setDetails(List<ErrorDetails> details) {
        this.details = details;
    }

    /**
     * Getter for Links.
     * An array of request-related [HATEOAS links](/api/rest/responses/#hateoas-links).
     * @return Returns the List of LinkDescription
     */
    @JsonGetter("links")
    public List<LinkDescription> getLinks() {
        return this.links;
    }

    /**
     * Setter for Links.
     * An array of request-related [HATEOAS links](/api/rest/responses/#hateoas-links).
     * @param links Value for List of LinkDescription
     */
    @JsonSetter("links")
    private void setLinks(List<LinkDescription> links) {
        this.links = links;
    }

    /**
     * Converts this ErrorException into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "ErrorException [" + "statusCode=" + getResponseCode() + ", message=" + getMessage()
                + ", name=" + name + ", message=" + message + ", debugId=" + debugId + ", details="
                + details + ", links=" + links + "]";
    }
}
