/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for CardRequest type.
 */
public class CardRequest {
    private String name;
    private String number;
    private String expiry;
    private String securityCode;
    private Address billingAddress;
    private CardAttributes attributes;
    private String vaultId;
    private String singleUseToken;
    private CardStoredCredential storedCredential;
    private NetworkToken networkToken;
    private CardExperienceContext experienceContext;

    /**
     * Default constructor.
     */
    public CardRequest() {
    }

    /**
     * Initialization constructor.
     * @param  name  String value for name.
     * @param  number  String value for number.
     * @param  expiry  String value for expiry.
     * @param  securityCode  String value for securityCode.
     * @param  billingAddress  Address value for billingAddress.
     * @param  attributes  CardAttributes value for attributes.
     * @param  vaultId  String value for vaultId.
     * @param  singleUseToken  String value for singleUseToken.
     * @param  storedCredential  CardStoredCredential value for storedCredential.
     * @param  networkToken  NetworkToken value for networkToken.
     * @param  experienceContext  CardExperienceContext value for experienceContext.
     */
    public CardRequest(
            String name,
            String number,
            String expiry,
            String securityCode,
            Address billingAddress,
            CardAttributes attributes,
            String vaultId,
            String singleUseToken,
            CardStoredCredential storedCredential,
            NetworkToken networkToken,
            CardExperienceContext experienceContext) {
        this.name = name;
        this.number = number;
        this.expiry = expiry;
        this.securityCode = securityCode;
        this.billingAddress = billingAddress;
        this.attributes = attributes;
        this.vaultId = vaultId;
        this.singleUseToken = singleUseToken;
        this.storedCredential = storedCredential;
        this.networkToken = networkToken;
        this.experienceContext = experienceContext;
    }

    /**
     * Getter for Name.
     * The card holder's name as it appears on the card.
     * @return Returns the String
     */
    @JsonGetter("name")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getName() {
        return name;
    }

    /**
     * Setter for Name.
     * The card holder's name as it appears on the card.
     * @param name Value for String
     */
    @JsonSetter("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Getter for Number.
     * The primary account number (PAN) for the payment card.
     * @return Returns the String
     */
    @JsonGetter("number")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getNumber() {
        return number;
    }

    /**
     * Setter for Number.
     * The primary account number (PAN) for the payment card.
     * @param number Value for String
     */
    @JsonSetter("number")
    public void setNumber(String number) {
        this.number = number;
    }

    /**
     * Getter for Expiry.
     * The year and month, in ISO-8601 `YYYY-MM` date format. See [Internet date and time
     * format](https://tools.ietf.org/html/rfc3339#section-5.6).
     * @return Returns the String
     */
    @JsonGetter("expiry")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getExpiry() {
        return expiry;
    }

    /**
     * Setter for Expiry.
     * The year and month, in ISO-8601 `YYYY-MM` date format. See [Internet date and time
     * format](https://tools.ietf.org/html/rfc3339#section-5.6).
     * @param expiry Value for String
     */
    @JsonSetter("expiry")
    public void setExpiry(String expiry) {
        this.expiry = expiry;
    }

    /**
     * Getter for SecurityCode.
     * The three- or four-digit security code of the card. Also known as the CVV, CVC, CVN, CVE, or
     * CID. This parameter cannot be present in the request when `payment_initiator=MERCHANT`.
     * @return Returns the String
     */
    @JsonGetter("security_code")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getSecurityCode() {
        return securityCode;
    }

    /**
     * Setter for SecurityCode.
     * The three- or four-digit security code of the card. Also known as the CVV, CVC, CVN, CVE, or
     * CID. This parameter cannot be present in the request when `payment_initiator=MERCHANT`.
     * @param securityCode Value for String
     */
    @JsonSetter("security_code")
    public void setSecurityCode(String securityCode) {
        this.securityCode = securityCode;
    }

    /**
     * Getter for BillingAddress.
     * The portable international postal address. Maps to
     * [AddressValidationMetadata](https://github.com/googlei18n/libaddressinput/wiki/AddressValidationMetadata)
     * and HTML 5.1 [Autofilling form controls: the autocomplete
     * attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-controls-the-autocomplete-attribute).
     * @return Returns the Address
     */
    @JsonGetter("billing_address")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Address getBillingAddress() {
        return billingAddress;
    }

    /**
     * Setter for BillingAddress.
     * The portable international postal address. Maps to
     * [AddressValidationMetadata](https://github.com/googlei18n/libaddressinput/wiki/AddressValidationMetadata)
     * and HTML 5.1 [Autofilling form controls: the autocomplete
     * attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-controls-the-autocomplete-attribute).
     * @param billingAddress Value for Address
     */
    @JsonSetter("billing_address")
    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    /**
     * Getter for Attributes.
     * Additional attributes associated with the use of this card.
     * @return Returns the CardAttributes
     */
    @JsonGetter("attributes")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public CardAttributes getAttributes() {
        return attributes;
    }

    /**
     * Setter for Attributes.
     * Additional attributes associated with the use of this card.
     * @param attributes Value for CardAttributes
     */
    @JsonSetter("attributes")
    public void setAttributes(CardAttributes attributes) {
        this.attributes = attributes;
    }

    /**
     * Getter for VaultId.
     * The PayPal-generated ID for the vaulted payment source. This ID should be stored on the
     * merchant's server so the saved payment source can be used for future transactions.
     * @return Returns the String
     */
    @JsonGetter("vault_id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getVaultId() {
        return vaultId;
    }

    /**
     * Setter for VaultId.
     * The PayPal-generated ID for the vaulted payment source. This ID should be stored on the
     * merchant's server so the saved payment source can be used for future transactions.
     * @param vaultId Value for String
     */
    @JsonSetter("vault_id")
    public void setVaultId(String vaultId) {
        this.vaultId = vaultId;
    }

    /**
     * Getter for SingleUseToken.
     * The PayPal-generated, short-lived, one-time-use token, used to communicate payment
     * information to PayPal for transaction processing.
     * @return Returns the String
     */
    @JsonGetter("single_use_token")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getSingleUseToken() {
        return singleUseToken;
    }

    /**
     * Setter for SingleUseToken.
     * The PayPal-generated, short-lived, one-time-use token, used to communicate payment
     * information to PayPal for transaction processing.
     * @param singleUseToken Value for String
     */
    @JsonSetter("single_use_token")
    public void setSingleUseToken(String singleUseToken) {
        this.singleUseToken = singleUseToken;
    }

    /**
     * Getter for StoredCredential.
     * Provides additional details to process a payment using a `card` that has been stored or is
     * intended to be stored (also referred to as stored_credential or card-on-file). Parameter
     * compatibility: `payment_type=ONE_TIME` is compatible only with `payment_initiator=CUSTOMER`.
     * `usage=FIRST` is compatible only with `payment_initiator=CUSTOMER`.
     * `previous_transaction_reference` or `previous_network_transaction_reference` is compatible
     * only with `payment_initiator=MERCHANT`. Only one of the parameters -
     * `previous_transaction_reference` and `previous_network_transaction_reference` - can be
     * present in the request.
     * @return Returns the CardStoredCredential
     */
    @JsonGetter("stored_credential")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public CardStoredCredential getStoredCredential() {
        return storedCredential;
    }

    /**
     * Setter for StoredCredential.
     * Provides additional details to process a payment using a `card` that has been stored or is
     * intended to be stored (also referred to as stored_credential or card-on-file). Parameter
     * compatibility: `payment_type=ONE_TIME` is compatible only with `payment_initiator=CUSTOMER`.
     * `usage=FIRST` is compatible only with `payment_initiator=CUSTOMER`.
     * `previous_transaction_reference` or `previous_network_transaction_reference` is compatible
     * only with `payment_initiator=MERCHANT`. Only one of the parameters -
     * `previous_transaction_reference` and `previous_network_transaction_reference` - can be
     * present in the request.
     * @param storedCredential Value for CardStoredCredential
     */
    @JsonSetter("stored_credential")
    public void setStoredCredential(CardStoredCredential storedCredential) {
        this.storedCredential = storedCredential;
    }

    /**
     * Getter for NetworkToken.
     * The Third Party Network token used to fund a payment.
     * @return Returns the NetworkToken
     */
    @JsonGetter("network_token")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public NetworkToken getNetworkToken() {
        return networkToken;
    }

    /**
     * Setter for NetworkToken.
     * The Third Party Network token used to fund a payment.
     * @param networkToken Value for NetworkToken
     */
    @JsonSetter("network_token")
    public void setNetworkToken(NetworkToken networkToken) {
        this.networkToken = networkToken;
    }

    /**
     * Getter for ExperienceContext.
     * Customizes the payer experience during the 3DS Approval for payment.
     * @return Returns the CardExperienceContext
     */
    @JsonGetter("experience_context")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public CardExperienceContext getExperienceContext() {
        return experienceContext;
    }

    /**
     * Setter for ExperienceContext.
     * Customizes the payer experience during the 3DS Approval for payment.
     * @param experienceContext Value for CardExperienceContext
     */
    @JsonSetter("experience_context")
    public void setExperienceContext(CardExperienceContext experienceContext) {
        this.experienceContext = experienceContext;
    }

    /**
     * Converts this CardRequest into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "CardRequest [" + "name=" + name + ", number=" + number + ", expiry=" + expiry
                + ", securityCode=" + securityCode + ", billingAddress=" + billingAddress
                + ", attributes=" + attributes + ", vaultId=" + vaultId + ", singleUseToken="
                + singleUseToken + ", storedCredential=" + storedCredential + ", networkToken="
                + networkToken + ", experienceContext=" + experienceContext + "]";
    }

    /**
     * Builds a new {@link CardRequest.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link CardRequest.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .name(getName())
                .number(getNumber())
                .expiry(getExpiry())
                .securityCode(getSecurityCode())
                .billingAddress(getBillingAddress())
                .attributes(getAttributes())
                .vaultId(getVaultId())
                .singleUseToken(getSingleUseToken())
                .storedCredential(getStoredCredential())
                .networkToken(getNetworkToken())
                .experienceContext(getExperienceContext());
        return builder;
    }

    /**
     * Class to build instances of {@link CardRequest}.
     */
    public static class Builder {
        private String name;
        private String number;
        private String expiry;
        private String securityCode;
        private Address billingAddress;
        private CardAttributes attributes;
        private String vaultId;
        private String singleUseToken;
        private CardStoredCredential storedCredential;
        private NetworkToken networkToken;
        private CardExperienceContext experienceContext;



        /**
         * Setter for name.
         * @param  name  String value for name.
         * @return Builder
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        /**
         * Setter for number.
         * @param  number  String value for number.
         * @return Builder
         */
        public Builder number(String number) {
            this.number = number;
            return this;
        }

        /**
         * Setter for expiry.
         * @param  expiry  String value for expiry.
         * @return Builder
         */
        public Builder expiry(String expiry) {
            this.expiry = expiry;
            return this;
        }

        /**
         * Setter for securityCode.
         * @param  securityCode  String value for securityCode.
         * @return Builder
         */
        public Builder securityCode(String securityCode) {
            this.securityCode = securityCode;
            return this;
        }

        /**
         * Setter for billingAddress.
         * @param  billingAddress  Address value for billingAddress.
         * @return Builder
         */
        public Builder billingAddress(Address billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        /**
         * Setter for attributes.
         * @param  attributes  CardAttributes value for attributes.
         * @return Builder
         */
        public Builder attributes(CardAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        /**
         * Setter for vaultId.
         * @param  vaultId  String value for vaultId.
         * @return Builder
         */
        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            return this;
        }

        /**
         * Setter for singleUseToken.
         * @param  singleUseToken  String value for singleUseToken.
         * @return Builder
         */
        public Builder singleUseToken(String singleUseToken) {
            this.singleUseToken = singleUseToken;
            return this;
        }

        /**
         * Setter for storedCredential.
         * @param  storedCredential  CardStoredCredential value for storedCredential.
         * @return Builder
         */
        public Builder storedCredential(CardStoredCredential storedCredential) {
            this.storedCredential = storedCredential;
            return this;
        }

        /**
         * Setter for networkToken.
         * @param  networkToken  NetworkToken value for networkToken.
         * @return Builder
         */
        public Builder networkToken(NetworkToken networkToken) {
            this.networkToken = networkToken;
            return this;
        }

        /**
         * Setter for experienceContext.
         * @param  experienceContext  CardExperienceContext value for experienceContext.
         * @return Builder
         */
        public Builder experienceContext(CardExperienceContext experienceContext) {
            this.experienceContext = experienceContext;
            return this;
        }

        /**
         * Builds a new {@link CardRequest} object using the set fields.
         * @return {@link CardRequest}
         */
        public CardRequest build() {
            return new CardRequest(name, number, expiry, securityCode, billingAddress, attributes,
                    vaultId, singleUseToken, storedCredential, networkToken, experienceContext);
        }
    }
}
