/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.List;

/**
 * This is a model class for Level3CardProcessingData type.
 */
public class Level3CardProcessingData {
    private Money shippingAmount;
    private Money dutyAmount;
    private Money discountAmount;
    private Address shippingAddress;
    private String shipsFromPostalCode;
    private List<LineItem> lineItems;

    /**
     * Default constructor.
     */
    public Level3CardProcessingData() {
    }

    /**
     * Initialization constructor.
     * @param  shippingAmount  Money value for shippingAmount.
     * @param  dutyAmount  Money value for dutyAmount.
     * @param  discountAmount  Money value for discountAmount.
     * @param  shippingAddress  Address value for shippingAddress.
     * @param  shipsFromPostalCode  String value for shipsFromPostalCode.
     * @param  lineItems  List of LineItem value for lineItems.
     */
    public Level3CardProcessingData(
            Money shippingAmount,
            Money dutyAmount,
            Money discountAmount,
            Address shippingAddress,
            String shipsFromPostalCode,
            List<LineItem> lineItems) {
        this.shippingAmount = shippingAmount;
        this.dutyAmount = dutyAmount;
        this.discountAmount = discountAmount;
        this.shippingAddress = shippingAddress;
        this.shipsFromPostalCode = shipsFromPostalCode;
        this.lineItems = lineItems;
    }

    /**
     * Getter for ShippingAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("shipping_amount")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getShippingAmount() {
        return shippingAmount;
    }

    /**
     * Setter for ShippingAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param shippingAmount Value for Money
     */
    @JsonSetter("shipping_amount")
    public void setShippingAmount(Money shippingAmount) {
        this.shippingAmount = shippingAmount;
    }

    /**
     * Getter for DutyAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("duty_amount")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getDutyAmount() {
        return dutyAmount;
    }

    /**
     * Setter for DutyAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param dutyAmount Value for Money
     */
    @JsonSetter("duty_amount")
    public void setDutyAmount(Money dutyAmount) {
        this.dutyAmount = dutyAmount;
    }

    /**
     * Getter for DiscountAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("discount_amount")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getDiscountAmount() {
        return discountAmount;
    }

    /**
     * Setter for DiscountAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param discountAmount Value for Money
     */
    @JsonSetter("discount_amount")
    public void setDiscountAmount(Money discountAmount) {
        this.discountAmount = discountAmount;
    }

    /**
     * Getter for ShippingAddress.
     * The portable international postal address. Maps to
     * [AddressValidationMetadata](https://github.com/googlei18n/libaddressinput/wiki/AddressValidationMetadata)
     * and HTML 5.1 [Autofilling form controls: the autocomplete
     * attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-controls-the-autocomplete-attribute).
     * @return Returns the Address
     */
    @JsonGetter("shipping_address")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Address getShippingAddress() {
        return shippingAddress;
    }

    /**
     * Setter for ShippingAddress.
     * The portable international postal address. Maps to
     * [AddressValidationMetadata](https://github.com/googlei18n/libaddressinput/wiki/AddressValidationMetadata)
     * and HTML 5.1 [Autofilling form controls: the autocomplete
     * attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-controls-the-autocomplete-attribute).
     * @param shippingAddress Value for Address
     */
    @JsonSetter("shipping_address")
    public void setShippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    /**
     * Getter for ShipsFromPostalCode.
     * Use this field to specify the postal code of the shipping location.
     * @return Returns the String
     */
    @JsonGetter("ships_from_postal_code")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getShipsFromPostalCode() {
        return shipsFromPostalCode;
    }

    /**
     * Setter for ShipsFromPostalCode.
     * Use this field to specify the postal code of the shipping location.
     * @param shipsFromPostalCode Value for String
     */
    @JsonSetter("ships_from_postal_code")
    public void setShipsFromPostalCode(String shipsFromPostalCode) {
        this.shipsFromPostalCode = shipsFromPostalCode;
    }

    /**
     * Getter for LineItems.
     * A list of the items that were purchased with this payment. If your merchant account has been
     * configured for Level 3 processing this field will be passed to the processor on your behalf.
     * @return Returns the List of LineItem
     */
    @JsonGetter("line_items")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public List<LineItem> getLineItems() {
        return lineItems;
    }

    /**
     * Setter for LineItems.
     * A list of the items that were purchased with this payment. If your merchant account has been
     * configured for Level 3 processing this field will be passed to the processor on your behalf.
     * @param lineItems Value for List of LineItem
     */
    @JsonSetter("line_items")
    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    /**
     * Converts this Level3CardProcessingData into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "Level3CardProcessingData [" + "shippingAmount=" + shippingAmount + ", dutyAmount="
                + dutyAmount + ", discountAmount=" + discountAmount + ", shippingAddress="
                + shippingAddress + ", shipsFromPostalCode=" + shipsFromPostalCode + ", lineItems="
                + lineItems + "]";
    }

    /**
     * Builds a new {@link Level3CardProcessingData.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link Level3CardProcessingData.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .shippingAmount(getShippingAmount())
                .dutyAmount(getDutyAmount())
                .discountAmount(getDiscountAmount())
                .shippingAddress(getShippingAddress())
                .shipsFromPostalCode(getShipsFromPostalCode())
                .lineItems(getLineItems());
        return builder;
    }

    /**
     * Class to build instances of {@link Level3CardProcessingData}.
     */
    public static class Builder {
        private Money shippingAmount;
        private Money dutyAmount;
        private Money discountAmount;
        private Address shippingAddress;
        private String shipsFromPostalCode;
        private List<LineItem> lineItems;



        /**
         * Setter for shippingAmount.
         * @param  shippingAmount  Money value for shippingAmount.
         * @return Builder
         */
        public Builder shippingAmount(Money shippingAmount) {
            this.shippingAmount = shippingAmount;
            return this;
        }

        /**
         * Setter for dutyAmount.
         * @param  dutyAmount  Money value for dutyAmount.
         * @return Builder
         */
        public Builder dutyAmount(Money dutyAmount) {
            this.dutyAmount = dutyAmount;
            return this;
        }

        /**
         * Setter for discountAmount.
         * @param  discountAmount  Money value for discountAmount.
         * @return Builder
         */
        public Builder discountAmount(Money discountAmount) {
            this.discountAmount = discountAmount;
            return this;
        }

        /**
         * Setter for shippingAddress.
         * @param  shippingAddress  Address value for shippingAddress.
         * @return Builder
         */
        public Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        /**
         * Setter for shipsFromPostalCode.
         * @param  shipsFromPostalCode  String value for shipsFromPostalCode.
         * @return Builder
         */
        public Builder shipsFromPostalCode(String shipsFromPostalCode) {
            this.shipsFromPostalCode = shipsFromPostalCode;
            return this;
        }

        /**
         * Setter for lineItems.
         * @param  lineItems  List of LineItem value for lineItems.
         * @return Builder
         */
        public Builder lineItems(List<LineItem> lineItems) {
            this.lineItems = lineItems;
            return this;
        }

        /**
         * Builds a new {@link Level3CardProcessingData} object using the set fields.
         * @return {@link Level3CardProcessingData}
         */
        public Level3CardProcessingData build() {
            return new Level3CardProcessingData(shippingAmount, dutyAmount, discountAmount,
                    shippingAddress, shipsFromPostalCode, lineItems);
        }
    }
}
