/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for OrderConfirmApplicationContext type.
 */
public class OrderConfirmApplicationContext {
    private String brandName;
    private String locale;
    private String returnUrl;
    private String cancelUrl;
    private StoredPaymentSource storedPaymentSource;

    /**
     * Default constructor.
     */
    public OrderConfirmApplicationContext() {
    }

    /**
     * Initialization constructor.
     * @param  brandName  String value for brandName.
     * @param  locale  String value for locale.
     * @param  returnUrl  String value for returnUrl.
     * @param  cancelUrl  String value for cancelUrl.
     * @param  storedPaymentSource  StoredPaymentSource value for storedPaymentSource.
     */
    public OrderConfirmApplicationContext(
            String brandName,
            String locale,
            String returnUrl,
            String cancelUrl,
            StoredPaymentSource storedPaymentSource) {
        this.brandName = brandName;
        this.locale = locale;
        this.returnUrl = returnUrl;
        this.cancelUrl = cancelUrl;
        this.storedPaymentSource = storedPaymentSource;
    }

    /**
     * Getter for BrandName.
     * Label to present to your payer as part of the PayPal hosted web experience.
     * @return Returns the String
     */
    @JsonGetter("brand_name")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getBrandName() {
        return brandName;
    }

    /**
     * Setter for BrandName.
     * Label to present to your payer as part of the PayPal hosted web experience.
     * @param brandName Value for String
     */
    @JsonSetter("brand_name")
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    /**
     * Getter for Locale.
     * The [language tag](https://tools.ietf.org/html/bcp47#section-2) for the language in which to
     * localize the error-related strings, such as messages, issues, and suggested actions. The tag
     * is made up of the [ISO 639-2 language
     * code](https://www.loc.gov/standards/iso639-2/php/code_list.php), the optional [ISO-15924
     * script tag](https://www.unicode.org/iso15924/codelists.html), and the [ISO-3166 alpha-2
     * country code](/api/rest/reference/country-codes/) or [M49 region
     * code](https://unstats.un.org/unsd/methodology/m49/).
     * @return Returns the String
     */
    @JsonGetter("locale")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getLocale() {
        return locale;
    }

    /**
     * Setter for Locale.
     * The [language tag](https://tools.ietf.org/html/bcp47#section-2) for the language in which to
     * localize the error-related strings, such as messages, issues, and suggested actions. The tag
     * is made up of the [ISO 639-2 language
     * code](https://www.loc.gov/standards/iso639-2/php/code_list.php), the optional [ISO-15924
     * script tag](https://www.unicode.org/iso15924/codelists.html), and the [ISO-3166 alpha-2
     * country code](/api/rest/reference/country-codes/) or [M49 region
     * code](https://unstats.un.org/unsd/methodology/m49/).
     * @param locale Value for String
     */
    @JsonSetter("locale")
    public void setLocale(String locale) {
        this.locale = locale;
    }

    /**
     * Getter for ReturnUrl.
     * The URL where the customer is redirected after the customer approves the payment.
     * @return Returns the String
     */
    @JsonGetter("return_url")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getReturnUrl() {
        return returnUrl;
    }

    /**
     * Setter for ReturnUrl.
     * The URL where the customer is redirected after the customer approves the payment.
     * @param returnUrl Value for String
     */
    @JsonSetter("return_url")
    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    /**
     * Getter for CancelUrl.
     * The URL where the customer is redirected after the customer cancels the payment.
     * @return Returns the String
     */
    @JsonGetter("cancel_url")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getCancelUrl() {
        return cancelUrl;
    }

    /**
     * Setter for CancelUrl.
     * The URL where the customer is redirected after the customer cancels the payment.
     * @param cancelUrl Value for String
     */
    @JsonSetter("cancel_url")
    public void setCancelUrl(String cancelUrl) {
        this.cancelUrl = cancelUrl;
    }

    /**
     * Getter for StoredPaymentSource.
     * Provides additional details to process a payment using a `payment_source` that has been
     * stored or is intended to be stored (also referred to as stored_credential or card-on-file).
     * Parameter compatibility: `payment_type=ONE_TIME` is compatible only with
     * `payment_initiator=CUSTOMER`. `usage=FIRST` is compatible only with
     * `payment_initiator=CUSTOMER`. `previous_transaction_reference` or
     * `previous_network_transaction_reference` is compatible only with
     * `payment_initiator=MERCHANT`. Only one of the parameters - `previous_transaction_reference`
     * and `previous_network_transaction_reference` - can be present in the request.
     * @return Returns the StoredPaymentSource
     */
    @JsonGetter("stored_payment_source")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public StoredPaymentSource getStoredPaymentSource() {
        return storedPaymentSource;
    }

    /**
     * Setter for StoredPaymentSource.
     * Provides additional details to process a payment using a `payment_source` that has been
     * stored or is intended to be stored (also referred to as stored_credential or card-on-file).
     * Parameter compatibility: `payment_type=ONE_TIME` is compatible only with
     * `payment_initiator=CUSTOMER`. `usage=FIRST` is compatible only with
     * `payment_initiator=CUSTOMER`. `previous_transaction_reference` or
     * `previous_network_transaction_reference` is compatible only with
     * `payment_initiator=MERCHANT`. Only one of the parameters - `previous_transaction_reference`
     * and `previous_network_transaction_reference` - can be present in the request.
     * @param storedPaymentSource Value for StoredPaymentSource
     */
    @JsonSetter("stored_payment_source")
    public void setStoredPaymentSource(StoredPaymentSource storedPaymentSource) {
        this.storedPaymentSource = storedPaymentSource;
    }

    /**
     * Converts this OrderConfirmApplicationContext into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "OrderConfirmApplicationContext [" + "brandName=" + brandName + ", locale=" + locale
                + ", returnUrl=" + returnUrl + ", cancelUrl=" + cancelUrl + ", storedPaymentSource="
                + storedPaymentSource + "]";
    }

    /**
     * Builds a new {@link OrderConfirmApplicationContext.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link OrderConfirmApplicationContext.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .brandName(getBrandName())
                .locale(getLocale())
                .returnUrl(getReturnUrl())
                .cancelUrl(getCancelUrl())
                .storedPaymentSource(getStoredPaymentSource());
        return builder;
    }

    /**
     * Class to build instances of {@link OrderConfirmApplicationContext}.
     */
    public static class Builder {
        private String brandName;
        private String locale;
        private String returnUrl;
        private String cancelUrl;
        private StoredPaymentSource storedPaymentSource;



        /**
         * Setter for brandName.
         * @param  brandName  String value for brandName.
         * @return Builder
         */
        public Builder brandName(String brandName) {
            this.brandName = brandName;
            return this;
        }

        /**
         * Setter for locale.
         * @param  locale  String value for locale.
         * @return Builder
         */
        public Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        /**
         * Setter for returnUrl.
         * @param  returnUrl  String value for returnUrl.
         * @return Builder
         */
        public Builder returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        /**
         * Setter for cancelUrl.
         * @param  cancelUrl  String value for cancelUrl.
         * @return Builder
         */
        public Builder cancelUrl(String cancelUrl) {
            this.cancelUrl = cancelUrl;
            return this;
        }

        /**
         * Setter for storedPaymentSource.
         * @param  storedPaymentSource  StoredPaymentSource value for storedPaymentSource.
         * @return Builder
         */
        public Builder storedPaymentSource(StoredPaymentSource storedPaymentSource) {
            this.storedPaymentSource = storedPaymentSource;
            return this;
        }

        /**
         * Builds a new {@link OrderConfirmApplicationContext} object using the set fields.
         * @return {@link OrderConfirmApplicationContext}
         */
        public OrderConfirmApplicationContext build() {
            return new OrderConfirmApplicationContext(brandName, locale, returnUrl, cancelUrl,
                    storedPaymentSource);
        }
    }
}
