/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.List;

/**
 * This is a model class for OrderUpdateCallbackRequest type.
 */
public class OrderUpdateCallbackRequest {
    private String id;
    private OrderUpdateCallbackShippingAddress shippingAddress;
    private OrderUpdateCallbackShippingOption shippingOption;
    private List<PurchaseUnitRequest> purchaseUnits;

    /**
     * Default constructor.
     */
    public OrderUpdateCallbackRequest() {
    }

    /**
     * Initialization constructor.
     * @param  shippingAddress  OrderUpdateCallbackShippingAddress value for shippingAddress.
     * @param  purchaseUnits  List of PurchaseUnitRequest value for purchaseUnits.
     * @param  id  String value for id.
     * @param  shippingOption  OrderUpdateCallbackShippingOption value for shippingOption.
     */
    public OrderUpdateCallbackRequest(
            OrderUpdateCallbackShippingAddress shippingAddress,
            List<PurchaseUnitRequest> purchaseUnits,
            String id,
            OrderUpdateCallbackShippingOption shippingOption) {
        this.id = id;
        this.shippingAddress = shippingAddress;
        this.shippingOption = shippingOption;
        this.purchaseUnits = purchaseUnits;
    }

    /**
     * Getter for Id.
     * The ID of the order.
     * @return Returns the String
     */
    @JsonGetter("id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getId() {
        return id;
    }

    /**
     * Setter for Id.
     * The ID of the order.
     * @param id Value for String
     */
    @JsonSetter("id")
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Getter for ShippingAddress.
     * The portable international postal address. Maps to
     * [AddressValidationMetadata](https://github.com/googlei18n/libaddressinput/wiki/AddressValidationMetadata)
     * and HTML 5.1 [Autofilling form controls: the autocomplete
     * attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-controls-the-autocomplete-attribute).
     * @return Returns the OrderUpdateCallbackShippingAddress
     */
    @JsonGetter("shipping_address")
    public OrderUpdateCallbackShippingAddress getShippingAddress() {
        return shippingAddress;
    }

    /**
     * Setter for ShippingAddress.
     * The portable international postal address. Maps to
     * [AddressValidationMetadata](https://github.com/googlei18n/libaddressinput/wiki/AddressValidationMetadata)
     * and HTML 5.1 [Autofilling form controls: the autocomplete
     * attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-controls-the-autocomplete-attribute).
     * @param shippingAddress Value for OrderUpdateCallbackShippingAddress
     */
    @JsonSetter("shipping_address")
    public void setShippingAddress(OrderUpdateCallbackShippingAddress shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    /**
     * Getter for ShippingOption.
     * The options that the payee or merchant offers to the payer to ship or pick up their items.
     * @return Returns the OrderUpdateCallbackShippingOption
     */
    @JsonGetter("shipping_option")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public OrderUpdateCallbackShippingOption getShippingOption() {
        return shippingOption;
    }

    /**
     * Setter for ShippingOption.
     * The options that the payee or merchant offers to the payer to ship or pick up their items.
     * @param shippingOption Value for OrderUpdateCallbackShippingOption
     */
    @JsonSetter("shipping_option")
    public void setShippingOption(OrderUpdateCallbackShippingOption shippingOption) {
        this.shippingOption = shippingOption;
    }

    /**
     * Getter for PurchaseUnits.
     * An array of purchase units. At present only 1 purchase_unit is supported. Each purchase unit
     * establishes a contract between a payer and the payee. Each purchase unit represents either a
     * full or partial order that the payer intends to purchase from the payee.
     * @return Returns the List of PurchaseUnitRequest
     */
    @JsonGetter("purchase_units")
    public List<PurchaseUnitRequest> getPurchaseUnits() {
        return purchaseUnits;
    }

    /**
     * Setter for PurchaseUnits.
     * An array of purchase units. At present only 1 purchase_unit is supported. Each purchase unit
     * establishes a contract between a payer and the payee. Each purchase unit represents either a
     * full or partial order that the payer intends to purchase from the payee.
     * @param purchaseUnits Value for List of PurchaseUnitRequest
     */
    @JsonSetter("purchase_units")
    public void setPurchaseUnits(List<PurchaseUnitRequest> purchaseUnits) {
        this.purchaseUnits = purchaseUnits;
    }

    /**
     * Converts this OrderUpdateCallbackRequest into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "OrderUpdateCallbackRequest [" + "shippingAddress=" + shippingAddress
                + ", purchaseUnits=" + purchaseUnits + ", id=" + id + ", shippingOption="
                + shippingOption + "]";
    }

    /**
     * Builds a new {@link OrderUpdateCallbackRequest.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link OrderUpdateCallbackRequest.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(shippingAddress, purchaseUnits)
                .id(getId())
                .shippingOption(getShippingOption());
        return builder;
    }

    /**
     * Class to build instances of {@link OrderUpdateCallbackRequest}.
     */
    public static class Builder {
        private OrderUpdateCallbackShippingAddress shippingAddress;
        private List<PurchaseUnitRequest> purchaseUnits;
        private String id;
        private OrderUpdateCallbackShippingOption shippingOption;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  shippingAddress  OrderUpdateCallbackShippingAddress value for shippingAddress.
         * @param  purchaseUnits  List of PurchaseUnitRequest value for purchaseUnits.
         */
        public Builder(OrderUpdateCallbackShippingAddress shippingAddress,
                List<PurchaseUnitRequest> purchaseUnits) {
            this.shippingAddress = shippingAddress;
            this.purchaseUnits = purchaseUnits;
        }

        /**
         * Setter for shippingAddress.
         * @param  shippingAddress  OrderUpdateCallbackShippingAddress value for shippingAddress.
         * @return Builder
         */
        public Builder shippingAddress(OrderUpdateCallbackShippingAddress shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        /**
         * Setter for purchaseUnits.
         * @param  purchaseUnits  List of PurchaseUnitRequest value for purchaseUnits.
         * @return Builder
         */
        public Builder purchaseUnits(List<PurchaseUnitRequest> purchaseUnits) {
            this.purchaseUnits = purchaseUnits;
            return this;
        }

        /**
         * Setter for id.
         * @param  id  String value for id.
         * @return Builder
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        /**
         * Setter for shippingOption.
         * @param  shippingOption  OrderUpdateCallbackShippingOption value for shippingOption.
         * @return Builder
         */
        public Builder shippingOption(OrderUpdateCallbackShippingOption shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        /**
         * Builds a new {@link OrderUpdateCallbackRequest} object using the set fields.
         * @return {@link OrderUpdateCallbackRequest}
         */
        public OrderUpdateCallbackRequest build() {
            return new OrderUpdateCallbackRequest(shippingAddress, purchaseUnits, id,
                    shippingOption);
        }
    }
}
