/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for RefundPlatformFee type.
 */
public class RefundPlatformFee {
    private Money amount;

    /**
     * Default constructor.
     */
    public RefundPlatformFee() {
    }

    /**
     * Initialization constructor.
     * @param  amount  Money value for amount.
     */
    public RefundPlatformFee(
            Money amount) {
        this.amount = amount;
    }

    /**
     * Getter for Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("amount")
    public Money getAmount() {
        return amount;
    }

    /**
     * Setter for Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param amount Value for Money
     */
    @JsonSetter("amount")
    public void setAmount(Money amount) {
        this.amount = amount;
    }

    /**
     * Converts this RefundPlatformFee into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "RefundPlatformFee [" + "amount=" + amount + "]";
    }

    /**
     * Builds a new {@link RefundPlatformFee.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link RefundPlatformFee.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(amount);
        return builder;
    }

    /**
     * Class to build instances of {@link RefundPlatformFee}.
     */
    public static class Builder {
        private Money amount;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  amount  Money value for amount.
         */
        public Builder(Money amount) {
            this.amount = amount;
        }

        /**
         * Setter for amount.
         * @param  amount  Money value for amount.
         * @return Builder
         */
        public Builder amount(Money amount) {
            this.amount = amount;
            return this;
        }

        /**
         * Builds a new {@link RefundPlatformFee} object using the set fields.
         * @return {@link RefundPlatformFee}
         */
        public RefundPlatformFee build() {
            return new RefundPlatformFee(amount);
        }
    }
}
