/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for VoidPaymentInput type.
 */
public class VoidPaymentInput {
    private String authorizationId;
    private String paypalMockResponse;
    private String paypalAuthAssertion;
    private String paypalRequestId;
    private String prefer;

    /**
     * Default constructor.
     */
    public VoidPaymentInput() {
        prefer = "return=minimal";
    }

    /**
     * Initialization constructor.
     * @param  authorizationId  String value for authorizationId.
     * @param  paypalMockResponse  String value for paypalMockResponse.
     * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
     * @param  paypalRequestId  String value for paypalRequestId.
     * @param  prefer  String value for prefer.
     */
    public VoidPaymentInput(
            String authorizationId,
            String paypalMockResponse,
            String paypalAuthAssertion,
            String paypalRequestId,
            String prefer) {
        this.authorizationId = authorizationId;
        this.paypalMockResponse = paypalMockResponse;
        this.paypalAuthAssertion = paypalAuthAssertion;
        this.paypalRequestId = paypalRequestId;
        this.prefer = prefer;
    }

    /**
     * Getter for AuthorizationId.
     * The PayPal-generated ID for the authorized payment to void.
     * @return Returns the String
     */
    @JsonGetter("authorization_id")
    public String getAuthorizationId() {
        return authorizationId;
    }

    /**
     * Setter for AuthorizationId.
     * The PayPal-generated ID for the authorized payment to void.
     * @param authorizationId Value for String
     */
    @JsonSetter("authorization_id")
    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    /**
     * Getter for PaypalMockResponse.
     * PayPal's REST API uses a request header to invoke negative testing in the sandbox. This
     * header configures the sandbox into a negative testing state for transactions that include the
     * merchant.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Mock-Response")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalMockResponse() {
        return paypalMockResponse;
    }

    /**
     * Setter for PaypalMockResponse.
     * PayPal's REST API uses a request header to invoke negative testing in the sandbox. This
     * header configures the sandbox into a negative testing state for transactions that include the
     * merchant.
     * @param paypalMockResponse Value for String
     */
    @JsonSetter("PayPal-Mock-Response")
    public void setPaypalMockResponse(String paypalMockResponse) {
        this.paypalMockResponse = paypalMockResponse;
    }

    /**
     * Getter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see
     * [PayPal-Auth-Assertion](/docs/api/reference/api-requests/#paypal-auth-assertion). Note:For
     * three party transactions in which a partner is managing the API calls on behalf of a
     * merchant, the partner must identify the merchant using either a PayPal-Auth-Assertion header
     * or an access token with target_subject.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Auth-Assertion")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalAuthAssertion() {
        return paypalAuthAssertion;
    }

    /**
     * Setter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see
     * [PayPal-Auth-Assertion](/docs/api/reference/api-requests/#paypal-auth-assertion). Note:For
     * three party transactions in which a partner is managing the API calls on behalf of a
     * merchant, the partner must identify the merchant using either a PayPal-Auth-Assertion header
     * or an access token with target_subject.
     * @param paypalAuthAssertion Value for String
     */
    @JsonSetter("PayPal-Auth-Assertion")
    public void setPaypalAuthAssertion(String paypalAuthAssertion) {
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    /**
     * Getter for PaypalRequestId.
     * The server stores keys for 45 days.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Request-Id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalRequestId() {
        return paypalRequestId;
    }

    /**
     * Setter for PaypalRequestId.
     * The server stores keys for 45 days.
     * @param paypalRequestId Value for String
     */
    @JsonSetter("PayPal-Request-Id")
    public void setPaypalRequestId(String paypalRequestId) {
        this.paypalRequestId = paypalRequestId;
    }

    /**
     * Getter for Prefer.
     * The preferred server response upon successful completion of the request. Value is:
     * return=minimal. The server returns a minimal response to optimize communication between the
     * API caller and the server. A minimal response includes the id, status and HATEOAS links.
     * return=representation. The server returns a complete resource representation, including the
     * current state of the resource.
     * @return Returns the String
     */
    @JsonGetter("Prefer")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPrefer() {
        return prefer;
    }

    /**
     * Setter for Prefer.
     * The preferred server response upon successful completion of the request. Value is:
     * return=minimal. The server returns a minimal response to optimize communication between the
     * API caller and the server. A minimal response includes the id, status and HATEOAS links.
     * return=representation. The server returns a complete resource representation, including the
     * current state of the resource.
     * @param prefer Value for String
     */
    @JsonSetter("Prefer")
    public void setPrefer(String prefer) {
        this.prefer = prefer;
    }

    /**
     * Converts this VoidPaymentInput into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "VoidPaymentInput [" + "authorizationId=" + authorizationId + ", paypalMockResponse="
                + paypalMockResponse + ", paypalAuthAssertion=" + paypalAuthAssertion
                + ", paypalRequestId=" + paypalRequestId + ", prefer=" + prefer + "]";
    }

    /**
     * Builds a new {@link VoidPaymentInput.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link VoidPaymentInput.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(authorizationId)
                .paypalMockResponse(getPaypalMockResponse())
                .paypalAuthAssertion(getPaypalAuthAssertion())
                .paypalRequestId(getPaypalRequestId())
                .prefer(getPrefer());
        return builder;
    }

    /**
     * Class to build instances of {@link VoidPaymentInput}.
     */
    public static class Builder {
        private String authorizationId;
        private String paypalMockResponse;
        private String paypalAuthAssertion;
        private String paypalRequestId;
        private String prefer = "return=minimal";

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  authorizationId  String value for authorizationId.
         */
        public Builder(String authorizationId) {
            this.authorizationId = authorizationId;
        }

        /**
         * Setter for authorizationId.
         * @param  authorizationId  String value for authorizationId.
         * @return Builder
         */
        public Builder authorizationId(String authorizationId) {
            this.authorizationId = authorizationId;
            return this;
        }

        /**
         * Setter for paypalMockResponse.
         * @param  paypalMockResponse  String value for paypalMockResponse.
         * @return Builder
         */
        public Builder paypalMockResponse(String paypalMockResponse) {
            this.paypalMockResponse = paypalMockResponse;
            return this;
        }

        /**
         * Setter for paypalAuthAssertion.
         * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
         * @return Builder
         */
        public Builder paypalAuthAssertion(String paypalAuthAssertion) {
            this.paypalAuthAssertion = paypalAuthAssertion;
            return this;
        }

        /**
         * Setter for paypalRequestId.
         * @param  paypalRequestId  String value for paypalRequestId.
         * @return Builder
         */
        public Builder paypalRequestId(String paypalRequestId) {
            this.paypalRequestId = paypalRequestId;
            return this;
        }

        /**
         * Setter for prefer.
         * @param  prefer  String value for prefer.
         * @return Builder
         */
        public Builder prefer(String prefer) {
            this.prefer = prefer;
            return this;
        }

        /**
         * Builds a new {@link VoidPaymentInput} object using the set fields.
         * @return {@link VoidPaymentInput}
         */
        public VoidPaymentInput build() {
            return new VoidPaymentInput(authorizationId, paypalMockResponse, paypalAuthAssertion,
                    paypalRequestId, prefer);
        }
    }
}
