/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.controllers;

import com.paypal.sdk.ApiHelper;
import com.paypal.sdk.Server;
import com.paypal.sdk.controllers.BaseController;
import com.paypal.sdk.exceptions.ApiException;
import com.paypal.sdk.exceptions.OAuthProviderException;
import com.paypal.sdk.http.request.HttpMethod;
import com.paypal.sdk.http.response.ApiResponse;
import com.paypal.sdk.models.OAuthToken;
import com.paypal.sdk.models.RequestTokenInput;
import io.apimatic.core.ApiCall;
import io.apimatic.core.ErrorCase;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import io.apimatic.coreinterfaces.http.request.ResponseClassType;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class OAuthAuthorizationController
extends BaseController {
    public OAuthAuthorizationController(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    public ApiResponse<OAuthToken> requestToken(RequestTokenInput input, Map<String, Object> fieldParameters) throws ApiException, IOException {
        return (ApiResponse)this.prepareRequestTokenRequest(input, fieldParameters).execute();
    }

    public CompletableFuture<ApiResponse<OAuthToken>> requestTokenAsync(RequestTokenInput input, Map<String, Object> fieldParameters) {
        try {
            return this.prepareRequestTokenRequest(input, fieldParameters).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<OAuthToken>, ApiException> prepareRequestTokenRequest(RequestTokenInput input, Map<String, Object> fieldParameters) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v1/oauth2/token").formParam(param -> param.key("grant_type").value((Object)"client_credentials").isRequired(false)).formParam(param -> param.key("scope").value((Object)input.getScope()).isRequired(false)).formParam(fieldParameters).headerParam(param -> param.key("Authorization").value((Object)input.getAuthorization()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (OAuthToken)ApiHelper.deserialize((String)response, OAuthToken.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"OAuth 2 provider returned an error.", (reason, context) -> new OAuthProviderException(reason, context))).localErrorCase("401", ErrorCase.setReason((String)"OAuth 2 provider says client authentication failed.", (reason, context) -> new OAuthProviderException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

