/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.PricingScheme;
import com.paypal.sdk.models.TenureType;
import com.paypal.sdk.utilities.JsonValue;

public class BillingCycle {
    private TenureType tenureType;
    private PricingScheme pricingScheme;
    private JsonValue frequency;
    private Integer totalCycles;
    private Integer sequence;
    private String startDate;

    public BillingCycle() {
        this.totalCycles = 1;
        this.sequence = 1;
    }

    public BillingCycle(TenureType tenureType, PricingScheme pricingScheme, JsonValue frequency, Integer totalCycles, Integer sequence, String startDate) {
        this.tenureType = tenureType;
        this.pricingScheme = pricingScheme;
        this.frequency = frequency;
        this.totalCycles = totalCycles;
        this.sequence = sequence;
        this.startDate = startDate;
    }

    @JsonGetter(value="tenure_type")
    public TenureType getTenureType() {
        return this.tenureType;
    }

    @JsonSetter(value="tenure_type")
    public void setTenureType(TenureType tenureType) {
        this.tenureType = tenureType;
    }

    @JsonGetter(value="pricing_scheme")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PricingScheme getPricingScheme() {
        return this.pricingScheme;
    }

    @JsonSetter(value="pricing_scheme")
    public void setPricingScheme(PricingScheme pricingScheme) {
        this.pricingScheme = pricingScheme;
    }

    @JsonGetter(value="frequency")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public JsonValue getFrequency() {
        return this.frequency;
    }

    @JsonSetter(value="frequency")
    public void setFrequency(JsonValue frequency) {
        this.frequency = frequency;
    }

    @JsonGetter(value="total_cycles")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getTotalCycles() {
        return this.totalCycles;
    }

    @JsonSetter(value="total_cycles")
    public void setTotalCycles(Integer totalCycles) {
        this.totalCycles = totalCycles;
    }

    @JsonGetter(value="sequence")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getSequence() {
        return this.sequence;
    }

    @JsonSetter(value="sequence")
    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    @JsonGetter(value="start_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStartDate() {
        return this.startDate;
    }

    @JsonSetter(value="start_date")
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String toString() {
        return "BillingCycle [tenureType=" + (Object)((Object)this.tenureType) + ", pricingScheme=" + this.pricingScheme + ", frequency=" + (Object)((Object)this.frequency) + ", totalCycles=" + this.totalCycles + ", sequence=" + this.sequence + ", startDate=" + this.startDate + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.tenureType).pricingScheme(this.getPricingScheme()).frequency(this.getFrequency()).totalCycles(this.getTotalCycles()).sequence(this.getSequence()).startDate(this.getStartDate());
        return builder;
    }

    public static class Builder {
        private TenureType tenureType;
        private PricingScheme pricingScheme;
        private JsonValue frequency;
        private Integer totalCycles = 1;
        private Integer sequence = 1;
        private String startDate;

        public Builder() {
        }

        public Builder(TenureType tenureType) {
            this.tenureType = tenureType;
        }

        public Builder tenureType(TenureType tenureType) {
            this.tenureType = tenureType;
            return this;
        }

        public Builder pricingScheme(PricingScheme pricingScheme) {
            this.pricingScheme = pricingScheme;
            return this;
        }

        public Builder frequency(JsonValue frequency) {
            this.frequency = frequency;
            return this;
        }

        public Builder totalCycles(Integer totalCycles) {
            this.totalCycles = totalCycles;
            return this;
        }

        public Builder sequence(Integer sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public BillingCycle build() {
            return new BillingCycle(this.tenureType, this.pricingScheme, this.frequency, this.totalCycles, this.sequence, this.startDate);
        }
    }
}

