/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.Money;

public class Level2CardProcessingData {
    private String invoiceId;
    private Money taxTotal;

    public Level2CardProcessingData() {
    }

    public Level2CardProcessingData(String invoiceId, Money taxTotal) {
        this.invoiceId = invoiceId;
        this.taxTotal = taxTotal;
    }

    @JsonGetter(value="invoice_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getInvoiceId() {
        return this.invoiceId;
    }

    @JsonSetter(value="invoice_id")
    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    @JsonGetter(value="tax_total")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTaxTotal() {
        return this.taxTotal;
    }

    @JsonSetter(value="tax_total")
    public void setTaxTotal(Money taxTotal) {
        this.taxTotal = taxTotal;
    }

    public String toString() {
        return "Level2CardProcessingData [invoiceId=" + this.invoiceId + ", taxTotal=" + this.taxTotal + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().invoiceId(this.getInvoiceId()).taxTotal(this.getTaxTotal());
        return builder;
    }

    public static class Builder {
        private String invoiceId;
        private Money taxTotal;

        public Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        public Builder taxTotal(Money taxTotal) {
            this.taxTotal = taxTotal;
            return this;
        }

        public Level2CardProcessingData build() {
            return new Level2CardProcessingData(this.invoiceId, this.taxTotal);
        }
    }
}

