/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.CallbackConfiguration;
import com.paypal.sdk.models.PayeePaymentMethodPreference;
import com.paypal.sdk.models.PaypalExperienceLandingPage;
import com.paypal.sdk.models.PaypalExperienceUserAction;
import com.paypal.sdk.models.PaypalWalletContextShippingPreference;

public class PaypalWalletExperienceContext {
    private String brandName;
    private String locale;
    private PaypalWalletContextShippingPreference shippingPreference;
    private String returnUrl;
    private String cancelUrl;
    private PaypalExperienceLandingPage landingPage;
    private PaypalExperienceUserAction userAction;
    private PayeePaymentMethodPreference paymentMethodPreference;
    private CallbackConfiguration orderUpdateCallbackConfig;

    public PaypalWalletExperienceContext() {
        this.shippingPreference = PaypalWalletContextShippingPreference.GET_FROM_FILE;
        this.landingPage = PaypalExperienceLandingPage.NO_PREFERENCE;
        this.userAction = PaypalExperienceUserAction.CONTINUE;
        this.paymentMethodPreference = PayeePaymentMethodPreference.UNRESTRICTED;
    }

    public PaypalWalletExperienceContext(String brandName, String locale, PaypalWalletContextShippingPreference shippingPreference, String returnUrl, String cancelUrl, PaypalExperienceLandingPage landingPage, PaypalExperienceUserAction userAction, PayeePaymentMethodPreference paymentMethodPreference, CallbackConfiguration orderUpdateCallbackConfig) {
        this.brandName = brandName;
        this.locale = locale;
        this.shippingPreference = shippingPreference;
        this.returnUrl = returnUrl;
        this.cancelUrl = cancelUrl;
        this.landingPage = landingPage;
        this.userAction = userAction;
        this.paymentMethodPreference = paymentMethodPreference;
        this.orderUpdateCallbackConfig = orderUpdateCallbackConfig;
    }

    @JsonGetter(value="brand_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBrandName() {
        return this.brandName;
    }

    @JsonSetter(value="brand_name")
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    @JsonGetter(value="locale")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocale() {
        return this.locale;
    }

    @JsonSetter(value="locale")
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @JsonGetter(value="shipping_preference")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PaypalWalletContextShippingPreference getShippingPreference() {
        return this.shippingPreference;
    }

    @JsonSetter(value="shipping_preference")
    public void setShippingPreference(PaypalWalletContextShippingPreference shippingPreference) {
        this.shippingPreference = shippingPreference;
    }

    @JsonGetter(value="return_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @JsonSetter(value="return_url")
    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    @JsonGetter(value="cancel_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCancelUrl() {
        return this.cancelUrl;
    }

    @JsonSetter(value="cancel_url")
    public void setCancelUrl(String cancelUrl) {
        this.cancelUrl = cancelUrl;
    }

    @JsonGetter(value="landing_page")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PaypalExperienceLandingPage getLandingPage() {
        return this.landingPage;
    }

    @JsonSetter(value="landing_page")
    public void setLandingPage(PaypalExperienceLandingPage landingPage) {
        this.landingPage = landingPage;
    }

    @JsonGetter(value="user_action")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PaypalExperienceUserAction getUserAction() {
        return this.userAction;
    }

    @JsonSetter(value="user_action")
    public void setUserAction(PaypalExperienceUserAction userAction) {
        this.userAction = userAction;
    }

    @JsonGetter(value="payment_method_preference")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PayeePaymentMethodPreference getPaymentMethodPreference() {
        return this.paymentMethodPreference;
    }

    @JsonSetter(value="payment_method_preference")
    public void setPaymentMethodPreference(PayeePaymentMethodPreference paymentMethodPreference) {
        this.paymentMethodPreference = paymentMethodPreference;
    }

    @JsonGetter(value="order_update_callback_config")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CallbackConfiguration getOrderUpdateCallbackConfig() {
        return this.orderUpdateCallbackConfig;
    }

    @JsonSetter(value="order_update_callback_config")
    public void setOrderUpdateCallbackConfig(CallbackConfiguration orderUpdateCallbackConfig) {
        this.orderUpdateCallbackConfig = orderUpdateCallbackConfig;
    }

    public String toString() {
        return "PaypalWalletExperienceContext [brandName=" + this.brandName + ", locale=" + this.locale + ", shippingPreference=" + (Object)((Object)this.shippingPreference) + ", returnUrl=" + this.returnUrl + ", cancelUrl=" + this.cancelUrl + ", landingPage=" + (Object)((Object)this.landingPage) + ", userAction=" + (Object)((Object)this.userAction) + ", paymentMethodPreference=" + (Object)((Object)this.paymentMethodPreference) + ", orderUpdateCallbackConfig=" + this.orderUpdateCallbackConfig + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().brandName(this.getBrandName()).locale(this.getLocale()).shippingPreference(this.getShippingPreference()).returnUrl(this.getReturnUrl()).cancelUrl(this.getCancelUrl()).landingPage(this.getLandingPage()).userAction(this.getUserAction()).paymentMethodPreference(this.getPaymentMethodPreference()).orderUpdateCallbackConfig(this.getOrderUpdateCallbackConfig());
        return builder;
    }

    public static class Builder {
        private String brandName;
        private String locale;
        private PaypalWalletContextShippingPreference shippingPreference = PaypalWalletContextShippingPreference.GET_FROM_FILE;
        private String returnUrl;
        private String cancelUrl;
        private PaypalExperienceLandingPage landingPage = PaypalExperienceLandingPage.NO_PREFERENCE;
        private PaypalExperienceUserAction userAction = PaypalExperienceUserAction.CONTINUE;
        private PayeePaymentMethodPreference paymentMethodPreference = PayeePaymentMethodPreference.UNRESTRICTED;
        private CallbackConfiguration orderUpdateCallbackConfig;

        public Builder brandName(String brandName) {
            this.brandName = brandName;
            return this;
        }

        public Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public Builder shippingPreference(PaypalWalletContextShippingPreference shippingPreference) {
            this.shippingPreference = shippingPreference;
            return this;
        }

        public Builder returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        public Builder cancelUrl(String cancelUrl) {
            this.cancelUrl = cancelUrl;
            return this;
        }

        public Builder landingPage(PaypalExperienceLandingPage landingPage) {
            this.landingPage = landingPage;
            return this;
        }

        public Builder userAction(PaypalExperienceUserAction userAction) {
            this.userAction = userAction;
            return this;
        }

        public Builder paymentMethodPreference(PayeePaymentMethodPreference paymentMethodPreference) {
            this.paymentMethodPreference = paymentMethodPreference;
            return this;
        }

        public Builder orderUpdateCallbackConfig(CallbackConfiguration orderUpdateCallbackConfig) {
            this.orderUpdateCallbackConfig = orderUpdateCallbackConfig;
            return this;
        }

        public PaypalWalletExperienceContext build() {
            return new PaypalWalletExperienceContext(this.brandName, this.locale, this.shippingPreference, this.returnUrl, this.cancelUrl, this.landingPage, this.userAction, this.paymentMethodPreference, this.orderUpdateCallbackConfig);
        }
    }
}

