/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.PaypalPaymentTokenCustomerType;
import com.paypal.sdk.models.PaypalPaymentTokenUsageType;
import com.paypal.sdk.models.UsagePattern;
import com.paypal.sdk.models.VaultVenmoExperienceContext;
import com.paypal.sdk.models.VaultedDigitalWalletShippingDetails;

public class VaultVenmoRequest {
    private String description;
    private UsagePattern usagePattern;
    private VaultedDigitalWalletShippingDetails shipping;
    private Boolean permitMultiplePaymentTokens;
    private PaypalPaymentTokenUsageType usageType;
    private PaypalPaymentTokenCustomerType customerType;
    private VaultVenmoExperienceContext experienceContext;

    public VaultVenmoRequest() {
        this.permitMultiplePaymentTokens = false;
    }

    public VaultVenmoRequest(String description, UsagePattern usagePattern, VaultedDigitalWalletShippingDetails shipping, Boolean permitMultiplePaymentTokens, PaypalPaymentTokenUsageType usageType, PaypalPaymentTokenCustomerType customerType, VaultVenmoExperienceContext experienceContext) {
        this.description = description;
        this.usagePattern = usagePattern;
        this.shipping = shipping;
        this.permitMultiplePaymentTokens = permitMultiplePaymentTokens;
        this.usageType = usageType;
        this.customerType = customerType;
        this.experienceContext = experienceContext;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonSetter(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonGetter(value="usage_pattern")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public UsagePattern getUsagePattern() {
        return this.usagePattern;
    }

    @JsonSetter(value="usage_pattern")
    public void setUsagePattern(UsagePattern usagePattern) {
        this.usagePattern = usagePattern;
    }

    @JsonGetter(value="shipping")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public VaultedDigitalWalletShippingDetails getShipping() {
        return this.shipping;
    }

    @JsonSetter(value="shipping")
    public void setShipping(VaultedDigitalWalletShippingDetails shipping) {
        this.shipping = shipping;
    }

    @JsonGetter(value="permit_multiple_payment_tokens")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getPermitMultiplePaymentTokens() {
        return this.permitMultiplePaymentTokens;
    }

    @JsonSetter(value="permit_multiple_payment_tokens")
    public void setPermitMultiplePaymentTokens(Boolean permitMultiplePaymentTokens) {
        this.permitMultiplePaymentTokens = permitMultiplePaymentTokens;
    }

    @JsonGetter(value="usage_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PaypalPaymentTokenUsageType getUsageType() {
        return this.usageType;
    }

    @JsonSetter(value="usage_type")
    public void setUsageType(PaypalPaymentTokenUsageType usageType) {
        this.usageType = usageType;
    }

    @JsonGetter(value="customer_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PaypalPaymentTokenCustomerType getCustomerType() {
        return this.customerType;
    }

    @JsonSetter(value="customer_type")
    public void setCustomerType(PaypalPaymentTokenCustomerType customerType) {
        this.customerType = customerType;
    }

    @JsonGetter(value="experience_context")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public VaultVenmoExperienceContext getExperienceContext() {
        return this.experienceContext;
    }

    @JsonSetter(value="experience_context")
    public void setExperienceContext(VaultVenmoExperienceContext experienceContext) {
        this.experienceContext = experienceContext;
    }

    public String toString() {
        return "VaultVenmoRequest [description=" + this.description + ", usagePattern=" + (Object)((Object)this.usagePattern) + ", shipping=" + this.shipping + ", permitMultiplePaymentTokens=" + this.permitMultiplePaymentTokens + ", usageType=" + (Object)((Object)this.usageType) + ", customerType=" + (Object)((Object)this.customerType) + ", experienceContext=" + this.experienceContext + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().description(this.getDescription()).usagePattern(this.getUsagePattern()).shipping(this.getShipping()).permitMultiplePaymentTokens(this.getPermitMultiplePaymentTokens()).usageType(this.getUsageType()).customerType(this.getCustomerType()).experienceContext(this.getExperienceContext());
        return builder;
    }

    public static class Builder {
        private String description;
        private UsagePattern usagePattern;
        private VaultedDigitalWalletShippingDetails shipping;
        private Boolean permitMultiplePaymentTokens = false;
        private PaypalPaymentTokenUsageType usageType;
        private PaypalPaymentTokenCustomerType customerType;
        private VaultVenmoExperienceContext experienceContext;

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder usagePattern(UsagePattern usagePattern) {
            this.usagePattern = usagePattern;
            return this;
        }

        public Builder shipping(VaultedDigitalWalletShippingDetails shipping) {
            this.shipping = shipping;
            return this;
        }

        public Builder permitMultiplePaymentTokens(Boolean permitMultiplePaymentTokens) {
            this.permitMultiplePaymentTokens = permitMultiplePaymentTokens;
            return this;
        }

        public Builder usageType(PaypalPaymentTokenUsageType usageType) {
            this.usageType = usageType;
            return this;
        }

        public Builder customerType(PaypalPaymentTokenCustomerType customerType) {
            this.customerType = customerType;
            return this;
        }

        public Builder experienceContext(VaultVenmoExperienceContext experienceContext) {
            this.experienceContext = experienceContext;
            return this;
        }

        public VaultVenmoRequest build() {
            return new VaultVenmoRequest(this.description, this.usagePattern, this.shipping, this.permitMultiplePaymentTokens, this.usageType, this.customerType, this.experienceContext);
        }
    }
}

