/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * CardBrand to be used.
 */
public enum CardBrand {
    /**
     * Visa card.
     */
    VISA,

    /**
     * Mastercard card.
     */
    MASTERCARD,

    /**
     * Discover card.
     */
    DISCOVER,

    /**
     * American Express card.
     */
    AMEX,

    /**
     * Solo debit card.
     */
    SOLO,

    /**
     * Japan Credit Bureau card.
     */
    JCB,

    /**
     * Military Star card.
     */
    STAR,

    /**
     * Delta Airlines card.
     */
    DELTA,

    /**
     * Switch credit card.
     */
    SWITCH,

    /**
     * Maestro credit card.
     */
    MAESTRO,

    /**
     * Carte Bancaire (CB) credit card.
     */
    CB_NATIONALE,

    /**
     * Configoga credit card.
     */
    CONFIGOGA,

    /**
     * Confidis credit card.
     */
    CONFIDIS,

    /**
     * Visa Electron credit card.
     */
    ELECTRON,

    /**
     * Cetelem credit card.
     */
    CETELEM,

    /**
     * China union pay credit card.
     */
    CHINA_UNION_PAY,

    /**
     * The Diners Club International banking and payment services capability network owned by Discover Financial Services (DFS), one of the most recognized brands in US financial services.
     */
    DINERS,

    /**
     * The Brazilian Elo card payment network.
     */
    ELO,

    /**
     * The Hiper - Ingenico ePayment network.
     */
    HIPER,

    /**
     * The Brazilian Hipercard payment network that's widely accepted in the retail market.
     */
    HIPERCARD,

    /**
     * The RuPay payment network.
     */
    RUPAY,

    /**
     * The GE Credit Union 3Point card payment network.
     */
    GE,

    /**
     * The Synchrony Financial (SYF) payment network.
     */
    SYNCHRONY,

    /**
     * The Electronic Fund Transfer At Point of Sale(EFTPOS) Debit card payment network.
     */
    EFTPOS,

    /**
     * UNKNOWN payment network.
     */
    UNKNOWN,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, CardBrand> valueMap = new TreeMap<>();
    private String value;

    static {
        VISA.value = "VISA";
        MASTERCARD.value = "MASTERCARD";
        DISCOVER.value = "DISCOVER";
        AMEX.value = "AMEX";
        SOLO.value = "SOLO";
        JCB.value = "JCB";
        STAR.value = "STAR";
        DELTA.value = "DELTA";
        SWITCH.value = "SWITCH";
        MAESTRO.value = "MAESTRO";
        CB_NATIONALE.value = "CB_NATIONALE";
        CONFIGOGA.value = "CONFIGOGA";
        CONFIDIS.value = "CONFIDIS";
        ELECTRON.value = "ELECTRON";
        CETELEM.value = "CETELEM";
        CHINA_UNION_PAY.value = "CHINA_UNION_PAY";
        DINERS.value = "DINERS";
        ELO.value = "ELO";
        HIPER.value = "HIPER";
        HIPERCARD.value = "HIPERCARD";
        RUPAY.value = "RUPAY";
        GE.value = "GE";
        SYNCHRONY.value = "SYNCHRONY";
        EFTPOS.value = "EFTPOS";
        UNKNOWN.value = "UNKNOWN";
        _UNKNOWN.value = null;

        valueMap.put("VISA", VISA);
        valueMap.put("MASTERCARD", MASTERCARD);
        valueMap.put("DISCOVER", DISCOVER);
        valueMap.put("AMEX", AMEX);
        valueMap.put("SOLO", SOLO);
        valueMap.put("JCB", JCB);
        valueMap.put("STAR", STAR);
        valueMap.put("DELTA", DELTA);
        valueMap.put("SWITCH", SWITCH);
        valueMap.put("MAESTRO", MAESTRO);
        valueMap.put("CB_NATIONALE", CB_NATIONALE);
        valueMap.put("CONFIGOGA", CONFIGOGA);
        valueMap.put("CONFIDIS", CONFIDIS);
        valueMap.put("ELECTRON", ELECTRON);
        valueMap.put("CETELEM", CETELEM);
        valueMap.put("CHINA_UNION_PAY", CHINA_UNION_PAY);
        valueMap.put("DINERS", DINERS);
        valueMap.put("ELO", ELO);
        valueMap.put("HIPER", HIPER);
        valueMap.put("HIPERCARD", HIPERCARD);
        valueMap.put("RUPAY", RUPAY);
        valueMap.put("GE", GE);
        valueMap.put("SYNCHRONY", SYNCHRONY);
        valueMap.put("EFTPOS", EFTPOS);
        valueMap.put("UNKNOWN", UNKNOWN);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static CardBrand constructFromString(String toConvert) throws IOException {
        CardBrand enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static CardBrand fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of CardBrand values to list of string values.
     * @param toConvert The list of CardBrand values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<CardBrand> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (CardBrand enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 