/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for P24PaymentObject type.
 */
public class P24PaymentObject {
    private String name;
    private String email;
    private String countryCode;
    private String paymentDescriptor;
    private String methodId;
    private String methodDescription;

    /**
     * Default constructor.
     */
    public P24PaymentObject() {
    }

    /**
     * Initialization constructor.
     * @param  name  String value for name.
     * @param  email  String value for email.
     * @param  countryCode  String value for countryCode.
     * @param  paymentDescriptor  String value for paymentDescriptor.
     * @param  methodId  String value for methodId.
     * @param  methodDescription  String value for methodDescription.
     */
    public P24PaymentObject(
            String name,
            String email,
            String countryCode,
            String paymentDescriptor,
            String methodId,
            String methodDescription) {
        this.name = name;
        this.email = email;
        this.countryCode = countryCode;
        this.paymentDescriptor = paymentDescriptor;
        this.methodId = methodId;
        this.methodDescription = methodDescription;
    }

    /**
     * Getter for Name.
     * The full name representation like Mr J Smith.
     * @return Returns the String
     */
    @JsonGetter("name")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getName() {
        return name;
    }

    /**
     * Setter for Name.
     * The full name representation like Mr J Smith.
     * @param name Value for String
     */
    @JsonSetter("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Getter for Email.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @return Returns the String
     */
    @JsonGetter("email")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getEmail() {
        return email;
    }

    /**
     * Setter for Email.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255
     * characters are allowed after the {@literal @} sign. However, the generally accepted maximum length for
     * an email address is 254 characters. The pattern verifies that an unquoted {@literal @} sign exists.
     * @param email Value for String
     */
    @JsonSetter("email")
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * Getter for CountryCode.
     * The [two-character ISO 3166-1 code](/api/rest/reference/country-codes/) that identifies the
     * country or region. Note: The country code for Great Britain is GB and not UK as used in the
     * top-level domain names for that country. Use the `C2` country code for China worldwide for
     * comparable uncontrolled price (CUP) method, bank card, and cross-border transactions.
     * @return Returns the String
     */
    @JsonGetter("country_code")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getCountryCode() {
        return countryCode;
    }

    /**
     * Setter for CountryCode.
     * The [two-character ISO 3166-1 code](/api/rest/reference/country-codes/) that identifies the
     * country or region. Note: The country code for Great Britain is GB and not UK as used in the
     * top-level domain names for that country. Use the `C2` country code for China worldwide for
     * comparable uncontrolled price (CUP) method, bank card, and cross-border transactions.
     * @param countryCode Value for String
     */
    @JsonSetter("country_code")
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /**
     * Getter for PaymentDescriptor.
     * P24 generated payment description.
     * @return Returns the String
     */
    @JsonGetter("payment_descriptor")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaymentDescriptor() {
        return paymentDescriptor;
    }

    /**
     * Setter for PaymentDescriptor.
     * P24 generated payment description.
     * @param paymentDescriptor Value for String
     */
    @JsonSetter("payment_descriptor")
    public void setPaymentDescriptor(String paymentDescriptor) {
        this.paymentDescriptor = paymentDescriptor;
    }

    /**
     * Getter for MethodId.
     * Numeric identifier of the payment scheme or bank used for the payment.
     * @return Returns the String
     */
    @JsonGetter("method_id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getMethodId() {
        return methodId;
    }

    /**
     * Setter for MethodId.
     * Numeric identifier of the payment scheme or bank used for the payment.
     * @param methodId Value for String
     */
    @JsonSetter("method_id")
    public void setMethodId(String methodId) {
        this.methodId = methodId;
    }

    /**
     * Getter for MethodDescription.
     * Friendly name of the payment scheme or bank used for the payment.
     * @return Returns the String
     */
    @JsonGetter("method_description")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getMethodDescription() {
        return methodDescription;
    }

    /**
     * Setter for MethodDescription.
     * Friendly name of the payment scheme or bank used for the payment.
     * @param methodDescription Value for String
     */
    @JsonSetter("method_description")
    public void setMethodDescription(String methodDescription) {
        this.methodDescription = methodDescription;
    }

    /**
     * Converts this P24PaymentObject into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "P24PaymentObject [" + "name=" + name + ", email=" + email + ", countryCode="
                + countryCode + ", paymentDescriptor=" + paymentDescriptor + ", methodId="
                + methodId + ", methodDescription=" + methodDescription + "]";
    }

    /**
     * Builds a new {@link P24PaymentObject.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link P24PaymentObject.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .name(getName())
                .email(getEmail())
                .countryCode(getCountryCode())
                .paymentDescriptor(getPaymentDescriptor())
                .methodId(getMethodId())
                .methodDescription(getMethodDescription());
        return builder;
    }

    /**
     * Class to build instances of {@link P24PaymentObject}.
     */
    public static class Builder {
        private String name;
        private String email;
        private String countryCode;
        private String paymentDescriptor;
        private String methodId;
        private String methodDescription;



        /**
         * Setter for name.
         * @param  name  String value for name.
         * @return Builder
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        /**
         * Setter for email.
         * @param  email  String value for email.
         * @return Builder
         */
        public Builder email(String email) {
            this.email = email;
            return this;
        }

        /**
         * Setter for countryCode.
         * @param  countryCode  String value for countryCode.
         * @return Builder
         */
        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        /**
         * Setter for paymentDescriptor.
         * @param  paymentDescriptor  String value for paymentDescriptor.
         * @return Builder
         */
        public Builder paymentDescriptor(String paymentDescriptor) {
            this.paymentDescriptor = paymentDescriptor;
            return this;
        }

        /**
         * Setter for methodId.
         * @param  methodId  String value for methodId.
         * @return Builder
         */
        public Builder methodId(String methodId) {
            this.methodId = methodId;
            return this;
        }

        /**
         * Setter for methodDescription.
         * @param  methodDescription  String value for methodDescription.
         * @return Builder
         */
        public Builder methodDescription(String methodDescription) {
            this.methodDescription = methodDescription;
            return this;
        }

        /**
         * Builds a new {@link P24PaymentObject} object using the set fields.
         * @return {@link P24PaymentObject}
         */
        public P24PaymentObject build() {
            return new P24PaymentObject(name, email, countryCode, paymentDescriptor, methodId,
                    methodDescription);
        }
    }
}
