/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for PricingScheme type.
 */
public class PricingScheme {
    private Money price;
    private PricingModel pricingModel;
    private Money reloadThresholdAmount;

    /**
     * Default constructor.
     */
    public PricingScheme() {
    }

    /**
     * Initialization constructor.
     * @param  pricingModel  PricingModel value for pricingModel.
     * @param  price  Money value for price.
     * @param  reloadThresholdAmount  Money value for reloadThresholdAmount.
     */
    public PricingScheme(
            PricingModel pricingModel,
            Money price,
            Money reloadThresholdAmount) {
        this.price = price;
        this.pricingModel = pricingModel;
        this.reloadThresholdAmount = reloadThresholdAmount;
    }

    /**
     * Getter for Price.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("price")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getPrice() {
        return price;
    }

    /**
     * Setter for Price.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param price Value for Money
     */
    @JsonSetter("price")
    public void setPrice(Money price) {
        this.price = price;
    }

    /**
     * Getter for PricingModel.
     * The pricing model for the billing cycle.
     * @return Returns the PricingModel
     */
    @JsonGetter("pricing_model")
    public PricingModel getPricingModel() {
        return pricingModel;
    }

    /**
     * Setter for PricingModel.
     * The pricing model for the billing cycle.
     * @param pricingModel Value for PricingModel
     */
    @JsonSetter("pricing_model")
    public void setPricingModel(PricingModel pricingModel) {
        this.pricingModel = pricingModel;
    }

    /**
     * Getter for ReloadThresholdAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("reload_threshold_amount")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getReloadThresholdAmount() {
        return reloadThresholdAmount;
    }

    /**
     * Setter for ReloadThresholdAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param reloadThresholdAmount Value for Money
     */
    @JsonSetter("reload_threshold_amount")
    public void setReloadThresholdAmount(Money reloadThresholdAmount) {
        this.reloadThresholdAmount = reloadThresholdAmount;
    }

    /**
     * Converts this PricingScheme into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "PricingScheme [" + "pricingModel=" + pricingModel + ", price=" + price
                + ", reloadThresholdAmount=" + reloadThresholdAmount + "]";
    }

    /**
     * Builds a new {@link PricingScheme.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link PricingScheme.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(pricingModel)
                .price(getPrice())
                .reloadThresholdAmount(getReloadThresholdAmount());
        return builder;
    }

    /**
     * Class to build instances of {@link PricingScheme}.
     */
    public static class Builder {
        private PricingModel pricingModel;
        private Money price;
        private Money reloadThresholdAmount;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  pricingModel  PricingModel value for pricingModel.
         */
        public Builder(PricingModel pricingModel) {
            this.pricingModel = pricingModel;
        }

        /**
         * Setter for pricingModel.
         * @param  pricingModel  PricingModel value for pricingModel.
         * @return Builder
         */
        public Builder pricingModel(PricingModel pricingModel) {
            this.pricingModel = pricingModel;
            return this;
        }

        /**
         * Setter for price.
         * @param  price  Money value for price.
         * @return Builder
         */
        public Builder price(Money price) {
            this.price = price;
            return this;
        }

        /**
         * Setter for reloadThresholdAmount.
         * @param  reloadThresholdAmount  Money value for reloadThresholdAmount.
         * @return Builder
         */
        public Builder reloadThresholdAmount(Money reloadThresholdAmount) {
            this.reloadThresholdAmount = reloadThresholdAmount;
            return this;
        }

        /**
         * Builds a new {@link PricingScheme} object using the set fields.
         * @return {@link PricingScheme}
         */
        public PricingScheme build() {
            return new PricingScheme(pricingModel, price, reloadThresholdAmount);
        }
    }
}
