/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.utilities.JsonValue;
import java.util.List;

/**
 * This is a model class for PurchaseUnit type.
 */
public class PurchaseUnit {
    private String referenceId;
    private AmountWithBreakdown amount;
    private PayeeBase payee;
    private PaymentInstruction paymentInstruction;
    private String description;
    private String customId;
    private String invoiceId;
    private String id;
    private String softDescriptor;
    private List<Item> items;
    private ShippingWithTrackingDetails shipping;
    private SupplementaryData supplementaryData;
    private PaymentCollection payments;
    private List<JsonValue> mostRecentErrors;

    /**
     * Default constructor.
     */
    public PurchaseUnit() {
    }

    /**
     * Initialization constructor.
     * @param  referenceId  String value for referenceId.
     * @param  amount  AmountWithBreakdown value for amount.
     * @param  payee  PayeeBase value for payee.
     * @param  paymentInstruction  PaymentInstruction value for paymentInstruction.
     * @param  description  String value for description.
     * @param  customId  String value for customId.
     * @param  invoiceId  String value for invoiceId.
     * @param  id  String value for id.
     * @param  softDescriptor  String value for softDescriptor.
     * @param  items  List of Item value for items.
     * @param  shipping  ShippingWithTrackingDetails value for shipping.
     * @param  supplementaryData  SupplementaryData value for supplementaryData.
     * @param  payments  PaymentCollection value for payments.
     * @param  mostRecentErrors  List of JsonValue value for mostRecentErrors.
     */
    public PurchaseUnit(
            String referenceId,
            AmountWithBreakdown amount,
            PayeeBase payee,
            PaymentInstruction paymentInstruction,
            String description,
            String customId,
            String invoiceId,
            String id,
            String softDescriptor,
            List<Item> items,
            ShippingWithTrackingDetails shipping,
            SupplementaryData supplementaryData,
            PaymentCollection payments,
            List<JsonValue> mostRecentErrors) {
        this.referenceId = referenceId;
        this.amount = amount;
        this.payee = payee;
        this.paymentInstruction = paymentInstruction;
        this.description = description;
        this.customId = customId;
        this.invoiceId = invoiceId;
        this.id = id;
        this.softDescriptor = softDescriptor;
        this.items = items;
        this.shipping = shipping;
        this.supplementaryData = supplementaryData;
        this.payments = payments;
        this.mostRecentErrors = mostRecentErrors;
    }

    /**
     * Getter for ReferenceId.
     * The API caller-provided external ID for the purchase unit. Required for multiple purchase
     * units when you must update the order through `PATCH`. If you omit this value and the order
     * contains only one purchase unit, PayPal sets this value to `default`. Note: If there are
     * multiple purchase units, reference_id is required for each purchase unit.
     * @return Returns the String
     */
    @JsonGetter("reference_id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return referenceId;
    }

    /**
     * Setter for ReferenceId.
     * The API caller-provided external ID for the purchase unit. Required for multiple purchase
     * units when you must update the order through `PATCH`. If you omit this value and the order
     * contains only one purchase unit, PayPal sets this value to `default`. Note: If there are
     * multiple purchase units, reference_id is required for each purchase unit.
     * @param referenceId Value for String
     */
    @JsonSetter("reference_id")
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    /**
     * Getter for Amount.
     * The total order amount with an optional breakdown that provides details, such as the total
     * item amount, total tax amount, shipping, handling, insurance, and discounts, if any. If you
     * specify `amount.breakdown`, the amount equals `item_total` plus `tax_total` plus `shipping`
     * plus `handling` plus `insurance` minus `shipping_discount` minus discount. The amount must be
     * a positive number. For listed of supported currencies and decimal precision, see the PayPal
     * REST APIs Currency Codes.
     * @return Returns the AmountWithBreakdown
     */
    @JsonGetter("amount")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public AmountWithBreakdown getAmount() {
        return amount;
    }

    /**
     * Setter for Amount.
     * The total order amount with an optional breakdown that provides details, such as the total
     * item amount, total tax amount, shipping, handling, insurance, and discounts, if any. If you
     * specify `amount.breakdown`, the amount equals `item_total` plus `tax_total` plus `shipping`
     * plus `handling` plus `insurance` minus `shipping_discount` minus discount. The amount must be
     * a positive number. For listed of supported currencies and decimal precision, see the PayPal
     * REST APIs Currency Codes.
     * @param amount Value for AmountWithBreakdown
     */
    @JsonSetter("amount")
    public void setAmount(AmountWithBreakdown amount) {
        this.amount = amount;
    }

    /**
     * Getter for Payee.
     * The merchant who receives the funds and fulfills the order. The merchant is also known as the
     * payee.
     * @return Returns the PayeeBase
     */
    @JsonGetter("payee")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PayeeBase getPayee() {
        return payee;
    }

    /**
     * Setter for Payee.
     * The merchant who receives the funds and fulfills the order. The merchant is also known as the
     * payee.
     * @param payee Value for PayeeBase
     */
    @JsonSetter("payee")
    public void setPayee(PayeeBase payee) {
        this.payee = payee;
    }

    /**
     * Getter for PaymentInstruction.
     * Any additional payment instructions to be consider during payment processing. This processing
     * instruction is applicable for Capturing an order or Authorizing an Order.
     * @return Returns the PaymentInstruction
     */
    @JsonGetter("payment_instruction")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PaymentInstruction getPaymentInstruction() {
        return paymentInstruction;
    }

    /**
     * Setter for PaymentInstruction.
     * Any additional payment instructions to be consider during payment processing. This processing
     * instruction is applicable for Capturing an order or Authorizing an Order.
     * @param paymentInstruction Value for PaymentInstruction
     */
    @JsonSetter("payment_instruction")
    public void setPaymentInstruction(PaymentInstruction paymentInstruction) {
        this.paymentInstruction = paymentInstruction;
    }

    /**
     * Getter for Description.
     * The purchase description.
     * @return Returns the String
     */
    @JsonGetter("description")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return description;
    }

    /**
     * Setter for Description.
     * The purchase description.
     * @param description Value for String
     */
    @JsonSetter("description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Getter for CustomId.
     * The API caller-provided external ID. Used to reconcile API caller-initiated transactions with
     * PayPal transactions. Appears in transaction and settlement reports.
     * @return Returns the String
     */
    @JsonGetter("custom_id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getCustomId() {
        return customId;
    }

    /**
     * Setter for CustomId.
     * The API caller-provided external ID. Used to reconcile API caller-initiated transactions with
     * PayPal transactions. Appears in transaction and settlement reports.
     * @param customId Value for String
     */
    @JsonSetter("custom_id")
    public void setCustomId(String customId) {
        this.customId = customId;
    }

    /**
     * Getter for InvoiceId.
     * The API caller-provided external invoice ID for this order.
     * @return Returns the String
     */
    @JsonGetter("invoice_id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getInvoiceId() {
        return invoiceId;
    }

    /**
     * Setter for InvoiceId.
     * The API caller-provided external invoice ID for this order.
     * @param invoiceId Value for String
     */
    @JsonSetter("invoice_id")
    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    /**
     * Getter for Id.
     * The PayPal-generated ID for the purchase unit. This ID appears in both the payer's
     * transaction history and the emails that the payer receives. In addition, this ID is available
     * in transaction and settlement reports that merchants and API callers can use to reconcile
     * transactions. This ID is only available when an order is saved by calling
     * v2/checkout/orders/id/save.
     * @return Returns the String
     */
    @JsonGetter("id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getId() {
        return id;
    }

    /**
     * Setter for Id.
     * The PayPal-generated ID for the purchase unit. This ID appears in both the payer's
     * transaction history and the emails that the payer receives. In addition, this ID is available
     * in transaction and settlement reports that merchants and API callers can use to reconcile
     * transactions. This ID is only available when an order is saved by calling
     * v2/checkout/orders/id/save.
     * @param id Value for String
     */
    @JsonSetter("id")
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Getter for SoftDescriptor.
     * The payment descriptor on account transactions on the customer's credit card statement, that
     * PayPal sends to processors. The maximum length of the soft descriptor information that you
     * can pass in the API field is 22 characters, in the following format:22 - len(PAYPAL * (8)) -
     * len(Descriptor in Payment Receiving Preferences of Merchant account + 1)The PAYPAL prefix
     * uses 8 characters. The soft descriptor supports the following ASCII characters: Alphanumeric
     * characters Dashes Asterisks Periods (.) Spaces For Wallet payments marketplace integrations:
     * The merchant descriptor in the Payment Receiving Preferences must be the marketplace name.
     * You can't use the remaining space to show the customer service number. The remaining spaces
     * can be a combination of seller name and country. For unbranded payments (Direct Card)
     * marketplace integrations, use a combination of the seller name and phone number.
     * @return Returns the String
     */
    @JsonGetter("soft_descriptor")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getSoftDescriptor() {
        return softDescriptor;
    }

    /**
     * Setter for SoftDescriptor.
     * The payment descriptor on account transactions on the customer's credit card statement, that
     * PayPal sends to processors. The maximum length of the soft descriptor information that you
     * can pass in the API field is 22 characters, in the following format:22 - len(PAYPAL * (8)) -
     * len(Descriptor in Payment Receiving Preferences of Merchant account + 1)The PAYPAL prefix
     * uses 8 characters. The soft descriptor supports the following ASCII characters: Alphanumeric
     * characters Dashes Asterisks Periods (.) Spaces For Wallet payments marketplace integrations:
     * The merchant descriptor in the Payment Receiving Preferences must be the marketplace name.
     * You can't use the remaining space to show the customer service number. The remaining spaces
     * can be a combination of seller name and country. For unbranded payments (Direct Card)
     * marketplace integrations, use a combination of the seller name and phone number.
     * @param softDescriptor Value for String
     */
    @JsonSetter("soft_descriptor")
    public void setSoftDescriptor(String softDescriptor) {
        this.softDescriptor = softDescriptor;
    }

    /**
     * Getter for Items.
     * An array of items that the customer purchases from the merchant.
     * @return Returns the List of Item
     */
    @JsonGetter("items")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public List<Item> getItems() {
        return items;
    }

    /**
     * Setter for Items.
     * An array of items that the customer purchases from the merchant.
     * @param items Value for List of Item
     */
    @JsonSetter("items")
    public void setItems(List<Item> items) {
        this.items = items;
    }

    /**
     * Getter for Shipping.
     * The order shipping details.
     * @return Returns the ShippingWithTrackingDetails
     */
    @JsonGetter("shipping")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public ShippingWithTrackingDetails getShipping() {
        return shipping;
    }

    /**
     * Setter for Shipping.
     * The order shipping details.
     * @param shipping Value for ShippingWithTrackingDetails
     */
    @JsonSetter("shipping")
    public void setShipping(ShippingWithTrackingDetails shipping) {
        this.shipping = shipping;
    }

    /**
     * Getter for SupplementaryData.
     * Supplementary data about a payment. This object passes information that can be used to
     * improve risk assessments and processing costs, for example, by providing Level 2 and Level 3
     * payment data.
     * @return Returns the SupplementaryData
     */
    @JsonGetter("supplementary_data")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public SupplementaryData getSupplementaryData() {
        return supplementaryData;
    }

    /**
     * Setter for SupplementaryData.
     * Supplementary data about a payment. This object passes information that can be used to
     * improve risk assessments and processing costs, for example, by providing Level 2 and Level 3
     * payment data.
     * @param supplementaryData Value for SupplementaryData
     */
    @JsonSetter("supplementary_data")
    public void setSupplementaryData(SupplementaryData supplementaryData) {
        this.supplementaryData = supplementaryData;
    }

    /**
     * Getter for Payments.
     * The collection of payments, or transactions, for a purchase unit in an order. For example,
     * authorized payments, captured payments, and refunds.
     * @return Returns the PaymentCollection
     */
    @JsonGetter("payments")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PaymentCollection getPayments() {
        return payments;
    }

    /**
     * Setter for Payments.
     * The collection of payments, or transactions, for a purchase unit in an order. For example,
     * authorized payments, captured payments, and refunds.
     * @param payments Value for PaymentCollection
     */
    @JsonSetter("payments")
    public void setPayments(PaymentCollection payments) {
        this.payments = payments;
    }

    /**
     * Getter for MostRecentErrors.
     * The error reason code and description that are the reason for the most recent order decline.
     * @return Returns the List of JsonValue
     */
    @JsonGetter("most_recent_errors")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public List<JsonValue> getMostRecentErrors() {
        return mostRecentErrors;
    }

    /**
     * Setter for MostRecentErrors.
     * The error reason code and description that are the reason for the most recent order decline.
     * @param mostRecentErrors Value for List of JsonValue
     */
    @JsonSetter("most_recent_errors")
    public void setMostRecentErrors(List<JsonValue> mostRecentErrors) {
        this.mostRecentErrors = mostRecentErrors;
    }

    /**
     * Converts this PurchaseUnit into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "PurchaseUnit [" + "referenceId=" + referenceId + ", amount=" + amount + ", payee="
                + payee + ", paymentInstruction=" + paymentInstruction + ", description="
                + description + ", customId=" + customId + ", invoiceId=" + invoiceId + ", id=" + id
                + ", softDescriptor=" + softDescriptor + ", items=" + items + ", shipping="
                + shipping + ", supplementaryData=" + supplementaryData + ", payments=" + payments
                + ", mostRecentErrors=" + mostRecentErrors + "]";
    }

    /**
     * Builds a new {@link PurchaseUnit.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link PurchaseUnit.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .referenceId(getReferenceId())
                .amount(getAmount())
                .payee(getPayee())
                .paymentInstruction(getPaymentInstruction())
                .description(getDescription())
                .customId(getCustomId())
                .invoiceId(getInvoiceId())
                .id(getId())
                .softDescriptor(getSoftDescriptor())
                .items(getItems())
                .shipping(getShipping())
                .supplementaryData(getSupplementaryData())
                .payments(getPayments())
                .mostRecentErrors(getMostRecentErrors());
        return builder;
    }

    /**
     * Class to build instances of {@link PurchaseUnit}.
     */
    public static class Builder {
        private String referenceId;
        private AmountWithBreakdown amount;
        private PayeeBase payee;
        private PaymentInstruction paymentInstruction;
        private String description;
        private String customId;
        private String invoiceId;
        private String id;
        private String softDescriptor;
        private List<Item> items;
        private ShippingWithTrackingDetails shipping;
        private SupplementaryData supplementaryData;
        private PaymentCollection payments;
        private List<JsonValue> mostRecentErrors;



        /**
         * Setter for referenceId.
         * @param  referenceId  String value for referenceId.
         * @return Builder
         */
        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        /**
         * Setter for amount.
         * @param  amount  AmountWithBreakdown value for amount.
         * @return Builder
         */
        public Builder amount(AmountWithBreakdown amount) {
            this.amount = amount;
            return this;
        }

        /**
         * Setter for payee.
         * @param  payee  PayeeBase value for payee.
         * @return Builder
         */
        public Builder payee(PayeeBase payee) {
            this.payee = payee;
            return this;
        }

        /**
         * Setter for paymentInstruction.
         * @param  paymentInstruction  PaymentInstruction value for paymentInstruction.
         * @return Builder
         */
        public Builder paymentInstruction(PaymentInstruction paymentInstruction) {
            this.paymentInstruction = paymentInstruction;
            return this;
        }

        /**
         * Setter for description.
         * @param  description  String value for description.
         * @return Builder
         */
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        /**
         * Setter for customId.
         * @param  customId  String value for customId.
         * @return Builder
         */
        public Builder customId(String customId) {
            this.customId = customId;
            return this;
        }

        /**
         * Setter for invoiceId.
         * @param  invoiceId  String value for invoiceId.
         * @return Builder
         */
        public Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        /**
         * Setter for id.
         * @param  id  String value for id.
         * @return Builder
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        /**
         * Setter for softDescriptor.
         * @param  softDescriptor  String value for softDescriptor.
         * @return Builder
         */
        public Builder softDescriptor(String softDescriptor) {
            this.softDescriptor = softDescriptor;
            return this;
        }

        /**
         * Setter for items.
         * @param  items  List of Item value for items.
         * @return Builder
         */
        public Builder items(List<Item> items) {
            this.items = items;
            return this;
        }

        /**
         * Setter for shipping.
         * @param  shipping  ShippingWithTrackingDetails value for shipping.
         * @return Builder
         */
        public Builder shipping(ShippingWithTrackingDetails shipping) {
            this.shipping = shipping;
            return this;
        }

        /**
         * Setter for supplementaryData.
         * @param  supplementaryData  SupplementaryData value for supplementaryData.
         * @return Builder
         */
        public Builder supplementaryData(SupplementaryData supplementaryData) {
            this.supplementaryData = supplementaryData;
            return this;
        }

        /**
         * Setter for payments.
         * @param  payments  PaymentCollection value for payments.
         * @return Builder
         */
        public Builder payments(PaymentCollection payments) {
            this.payments = payments;
            return this;
        }

        /**
         * Setter for mostRecentErrors.
         * @param  mostRecentErrors  List of JsonValue value for mostRecentErrors.
         * @return Builder
         */
        public Builder mostRecentErrors(List<JsonValue> mostRecentErrors) {
            this.mostRecentErrors = mostRecentErrors;
            return this;
        }

        /**
         * Builds a new {@link PurchaseUnit} object using the set fields.
         * @return {@link PurchaseUnit}
         */
        public PurchaseUnit build() {
            return new PurchaseUnit(referenceId, amount, payee, paymentInstruction, description,
                    customId, invoiceId, id, softDescriptor, items, shipping, supplementaryData,
                    payments, mostRecentErrors);
        }
    }
}
