/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for SetupTokenRequestPaymentSource type.
 */
public class SetupTokenRequestPaymentSource {
    private SetupTokenRequestCard card;
    private VaultPaypalWalletRequest paypal;
    private VaultVenmoRequest venmo;
    private VaultTokenRequest token;

    /**
     * Default constructor.
     */
    public SetupTokenRequestPaymentSource() {
    }

    /**
     * Initialization constructor.
     * @param  card  SetupTokenRequestCard value for card.
     * @param  paypal  VaultPaypalWalletRequest value for paypal.
     * @param  venmo  VaultVenmoRequest value for venmo.
     * @param  token  VaultTokenRequest value for token.
     */
    public SetupTokenRequestPaymentSource(
            SetupTokenRequestCard card,
            VaultPaypalWalletRequest paypal,
            VaultVenmoRequest venmo,
            VaultTokenRequest token) {
        this.card = card;
        this.paypal = paypal;
        this.venmo = venmo;
        this.token = token;
    }

    /**
     * Getter for Card.
     * A Resource representing a request to vault a Card.
     * @return Returns the SetupTokenRequestCard
     */
    @JsonGetter("card")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public SetupTokenRequestCard getCard() {
        return card;
    }

    /**
     * Setter for Card.
     * A Resource representing a request to vault a Card.
     * @param card Value for SetupTokenRequestCard
     */
    @JsonSetter("card")
    public void setCard(SetupTokenRequestCard card) {
        this.card = card;
    }

    /**
     * Getter for Paypal.
     * A resource representing a request to vault PayPal Wallet.
     * @return Returns the VaultPaypalWalletRequest
     */
    @JsonGetter("paypal")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public VaultPaypalWalletRequest getPaypal() {
        return paypal;
    }

    /**
     * Setter for Paypal.
     * A resource representing a request to vault PayPal Wallet.
     * @param paypal Value for VaultPaypalWalletRequest
     */
    @JsonSetter("paypal")
    public void setPaypal(VaultPaypalWalletRequest paypal) {
        this.paypal = paypal;
    }

    /**
     * Getter for Venmo.
     * @return Returns the VaultVenmoRequest
     */
    @JsonGetter("venmo")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public VaultVenmoRequest getVenmo() {
        return venmo;
    }

    /**
     * Setter for Venmo.
     * @param venmo Value for VaultVenmoRequest
     */
    @JsonSetter("venmo")
    public void setVenmo(VaultVenmoRequest venmo) {
        this.venmo = venmo;
    }

    /**
     * Getter for Token.
     * The Tokenized Payment Source representing a Request to Vault a Token.
     * @return Returns the VaultTokenRequest
     */
    @JsonGetter("token")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public VaultTokenRequest getToken() {
        return token;
    }

    /**
     * Setter for Token.
     * The Tokenized Payment Source representing a Request to Vault a Token.
     * @param token Value for VaultTokenRequest
     */
    @JsonSetter("token")
    public void setToken(VaultTokenRequest token) {
        this.token = token;
    }

    /**
     * Converts this SetupTokenRequestPaymentSource into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "SetupTokenRequestPaymentSource [" + "card=" + card + ", paypal=" + paypal
                + ", venmo=" + venmo + ", token=" + token + "]";
    }

    /**
     * Builds a new {@link SetupTokenRequestPaymentSource.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link SetupTokenRequestPaymentSource.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .card(getCard())
                .paypal(getPaypal())
                .venmo(getVenmo())
                .token(getToken());
        return builder;
    }

    /**
     * Class to build instances of {@link SetupTokenRequestPaymentSource}.
     */
    public static class Builder {
        private SetupTokenRequestCard card;
        private VaultPaypalWalletRequest paypal;
        private VaultVenmoRequest venmo;
        private VaultTokenRequest token;



        /**
         * Setter for card.
         * @param  card  SetupTokenRequestCard value for card.
         * @return Builder
         */
        public Builder card(SetupTokenRequestCard card) {
            this.card = card;
            return this;
        }

        /**
         * Setter for paypal.
         * @param  paypal  VaultPaypalWalletRequest value for paypal.
         * @return Builder
         */
        public Builder paypal(VaultPaypalWalletRequest paypal) {
            this.paypal = paypal;
            return this;
        }

        /**
         * Setter for venmo.
         * @param  venmo  VaultVenmoRequest value for venmo.
         * @return Builder
         */
        public Builder venmo(VaultVenmoRequest venmo) {
            this.venmo = venmo;
            return this;
        }

        /**
         * Setter for token.
         * @param  token  VaultTokenRequest value for token.
         * @return Builder
         */
        public Builder token(VaultTokenRequest token) {
            this.token = token;
            return this;
        }

        /**
         * Builds a new {@link SetupTokenRequestPaymentSource} object using the set fields.
         * @return {@link SetupTokenRequestPaymentSource}
         */
        public SetupTokenRequestPaymentSource build() {
            return new SetupTokenRequestPaymentSource(card, paypal, venmo, token);
        }
    }
}
