/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.List;

/**
 * This is a model class for VaultResponse type.
 */
public class VaultResponse {
    private String id;
    private VaultStatus status;
    private VaultCustomer customer;
    private List<LinkDescription> links;

    /**
     * Default constructor.
     */
    public VaultResponse() {
    }

    /**
     * Initialization constructor.
     * @param  id  String value for id.
     * @param  status  VaultStatus value for status.
     * @param  customer  VaultCustomer value for customer.
     * @param  links  List of LinkDescription value for links.
     */
    public VaultResponse(
            String id,
            VaultStatus status,
            VaultCustomer customer,
            List<LinkDescription> links) {
        this.id = id;
        this.status = status;
        this.customer = customer;
        this.links = links;
    }

    /**
     * Getter for Id.
     * The PayPal-generated ID for the saved payment source.
     * @return Returns the String
     */
    @JsonGetter("id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getId() {
        return id;
    }

    /**
     * Setter for Id.
     * The PayPal-generated ID for the saved payment source.
     * @param id Value for String
     */
    @JsonSetter("id")
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Getter for Status.
     * The vault status.
     * @return Returns the VaultStatus
     */
    @JsonGetter("status")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public VaultStatus getStatus() {
        return status;
    }

    /**
     * Setter for Status.
     * The vault status.
     * @param status Value for VaultStatus
     */
    @JsonSetter("status")
    public void setStatus(VaultStatus status) {
        this.status = status;
    }

    /**
     * Getter for Customer.
     * This object represents a merchant’s customer, allowing them to store contact details, and
     * track all payments associated with the same customer.
     * @return Returns the VaultCustomer
     */
    @JsonGetter("customer")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public VaultCustomer getCustomer() {
        return customer;
    }

    /**
     * Setter for Customer.
     * This object represents a merchant’s customer, allowing them to store contact details, and
     * track all payments associated with the same customer.
     * @param customer Value for VaultCustomer
     */
    @JsonSetter("customer")
    public void setCustomer(VaultCustomer customer) {
        this.customer = customer;
    }

    /**
     * Getter for Links.
     * An array of request-related HATEOAS links.
     * @return Returns the List of LinkDescription
     */
    @JsonGetter("links")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public List<LinkDescription> getLinks() {
        return links;
    }

    /**
     * Setter for Links.
     * An array of request-related HATEOAS links.
     * @param links Value for List of LinkDescription
     */
    @JsonSetter("links")
    public void setLinks(List<LinkDescription> links) {
        this.links = links;
    }

    /**
     * Converts this VaultResponse into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "VaultResponse [" + "id=" + id + ", status=" + status + ", customer=" + customer
                + ", links=" + links + "]";
    }

    /**
     * Builds a new {@link VaultResponse.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link VaultResponse.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .id(getId())
                .status(getStatus())
                .customer(getCustomer())
                .links(getLinks());
        return builder;
    }

    /**
     * Class to build instances of {@link VaultResponse}.
     */
    public static class Builder {
        private String id;
        private VaultStatus status;
        private VaultCustomer customer;
        private List<LinkDescription> links;



        /**
         * Setter for id.
         * @param  id  String value for id.
         * @return Builder
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        /**
         * Setter for status.
         * @param  status  VaultStatus value for status.
         * @return Builder
         */
        public Builder status(VaultStatus status) {
            this.status = status;
            return this;
        }

        /**
         * Setter for customer.
         * @param  customer  VaultCustomer value for customer.
         * @return Builder
         */
        public Builder customer(VaultCustomer customer) {
            this.customer = customer;
            return this;
        }

        /**
         * Setter for links.
         * @param  links  List of LinkDescription value for links.
         * @return Builder
         */
        public Builder links(List<LinkDescription> links) {
            this.links = links;
            return this;
        }

        /**
         * Builds a new {@link VaultResponse} object using the set fields.
         * @return {@link VaultResponse}
         */
        public VaultResponse build() {
            return new VaultResponse(id, status, customer, links);
        }
    }
}
