/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.utilities.JsonValue;
import java.util.List;

/**
 * This is a model class for VaultResponseCustomer type.
 */
public class VaultResponseCustomer {
    private String id;
    private String merchantCustomerId;
    private List<JsonValue> links;

    /**
     * Default constructor.
     */
    public VaultResponseCustomer() {
    }

    /**
     * Initialization constructor.
     * @param  id  String value for id.
     * @param  merchantCustomerId  String value for merchantCustomerId.
     * @param  links  List of JsonValue value for links.
     */
    public VaultResponseCustomer(
            String id,
            String merchantCustomerId,
            List<JsonValue> links) {
        this.id = id;
        this.merchantCustomerId = merchantCustomerId;
        this.links = links;
    }

    /**
     * Getter for Id.
     * The unique ID for a customer generated by PayPal.
     * @return Returns the String
     */
    @JsonGetter("id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getId() {
        return id;
    }

    /**
     * Setter for Id.
     * The unique ID for a customer generated by PayPal.
     * @param id Value for String
     */
    @JsonSetter("id")
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Getter for MerchantCustomerId.
     * Merchants and partners may already have a data-store where their customer information is
     * persisted. Use merchant_customer_id to associate the PayPal-generated customer.id to your
     * representation of a customer.
     * @return Returns the String
     */
    @JsonGetter("merchant_customer_id")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getMerchantCustomerId() {
        return merchantCustomerId;
    }

    /**
     * Setter for MerchantCustomerId.
     * Merchants and partners may already have a data-store where their customer information is
     * persisted. Use merchant_customer_id to associate the PayPal-generated customer.id to your
     * representation of a customer.
     * @param merchantCustomerId Value for String
     */
    @JsonSetter("merchant_customer_id")
    public void setMerchantCustomerId(String merchantCustomerId) {
        this.merchantCustomerId = merchantCustomerId;
    }

    /**
     * Getter for Links.
     * DEPRECATED. This field is DEPRECATED.
     * @return Returns the List of JsonValue
     */
    @JsonGetter("links")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public List<JsonValue> getLinks() {
        return links;
    }

    /**
     * Setter for Links.
     * DEPRECATED. This field is DEPRECATED.
     * @param links Value for List of JsonValue
     */
    @JsonSetter("links")
    public void setLinks(List<JsonValue> links) {
        this.links = links;
    }

    /**
     * Converts this VaultResponseCustomer into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "VaultResponseCustomer [" + "id=" + id + ", merchantCustomerId=" + merchantCustomerId
                + ", links=" + links + "]";
    }

    /**
     * Builds a new {@link VaultResponseCustomer.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link VaultResponseCustomer.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .id(getId())
                .merchantCustomerId(getMerchantCustomerId())
                .links(getLinks());
        return builder;
    }

    /**
     * Class to build instances of {@link VaultResponseCustomer}.
     */
    public static class Builder {
        private String id;
        private String merchantCustomerId;
        private List<JsonValue> links;



        /**
         * Setter for id.
         * @param  id  String value for id.
         * @return Builder
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        /**
         * Setter for merchantCustomerId.
         * @param  merchantCustomerId  String value for merchantCustomerId.
         * @return Builder
         */
        public Builder merchantCustomerId(String merchantCustomerId) {
            this.merchantCustomerId = merchantCustomerId;
            return this;
        }

        /**
         * Setter for links.
         * @param  links  List of JsonValue value for links.
         * @return Builder
         */
        public Builder links(List<JsonValue> links) {
            this.links = links;
            return this;
        }

        /**
         * Builds a new {@link VaultResponseCustomer} object using the set fields.
         * @return {@link VaultResponseCustomer}
         */
        public VaultResponseCustomer build() {
            return new VaultResponseCustomer(id, merchantCustomerId, links);
        }
    }
}
