/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for VaultTokenRequest type.
 */
public class VaultTokenRequest {
    private String id;
    private VaultTokenRequestType type;

    /**
     * Default constructor.
     */
    public VaultTokenRequest() {
    }

    /**
     * Initialization constructor.
     * @param  id  String value for id.
     * @param  type  VaultTokenRequestType value for type.
     */
    public VaultTokenRequest(
            String id,
            VaultTokenRequestType type) {
        this.id = id;
        this.type = type;
    }

    /**
     * Getter for Id.
     * The PayPal-generated ID for the token.
     * @return Returns the String
     */
    @JsonGetter("id")
    public String getId() {
        return id;
    }

    /**
     * Setter for Id.
     * The PayPal-generated ID for the token.
     * @param id Value for String
     */
    @JsonSetter("id")
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Getter for Type.
     * The tokenization method that generated the ID.
     * @return Returns the VaultTokenRequestType
     */
    @JsonGetter("type")
    public VaultTokenRequestType getType() {
        return type;
    }

    /**
     * Setter for Type.
     * The tokenization method that generated the ID.
     * @param type Value for VaultTokenRequestType
     */
    @JsonSetter("type")
    public void setType(VaultTokenRequestType type) {
        this.type = type;
    }

    /**
     * Converts this VaultTokenRequest into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "VaultTokenRequest [" + "id=" + id + ", type=" + type + "]";
    }

    /**
     * Builds a new {@link VaultTokenRequest.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link VaultTokenRequest.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(id, type);
        return builder;
    }

    /**
     * Class to build instances of {@link VaultTokenRequest}.
     */
    public static class Builder {
        private String id;
        private VaultTokenRequestType type;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  id  String value for id.
         * @param  type  VaultTokenRequestType value for type.
         */
        public Builder(String id, VaultTokenRequestType type) {
            this.id = id;
            this.type = type;
        }

        /**
         * Setter for id.
         * @param  id  String value for id.
         * @return Builder
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        /**
         * Setter for type.
         * @param  type  VaultTokenRequestType value for type.
         * @return Builder
         */
        public Builder type(VaultTokenRequestType type) {
            this.type = type;
            return this;
        }

        /**
         * Builds a new {@link VaultTokenRequest} object using the set fields.
         * @return {@link VaultTokenRequest}
         */
        public VaultTokenRequest build() {
            return new VaultTokenRequest(id, type);
        }
    }
}
