/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;

public final class AbstractClassNameCheck
extends AbstractFormatCheck {
    private static final String DEFAULT_FORMAT = "^Abstract.*$|^.*Factory$";
    private boolean mIgnoreModifier;
    private boolean mIgnoreName;

    public AbstractClassNameCheck() {
        super(DEFAULT_FORMAT);
    }

    public void setIgnoreModifier(boolean aValue) {
        this.mIgnoreModifier = aValue;
    }

    public void setIgnoreName(boolean aValue) {
        this.mIgnoreName = aValue;
    }

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST aAST) {
        if (14 == aAST.getType()) {
            this.visitClassDef(aAST);
        }
    }

    private void visitClassDef(DetailAST aAST) {
        String className = aAST.findFirstToken(58).getText();
        if (this.isAbstract(aAST)) {
            if (!this.mIgnoreName && !this.isMatchingClassName(className)) {
                this.log(aAST.getLineNo(), aAST.getColumnNo(), "illegal.abstract.class.name", className, this.getFormat());
            }
        } else if (!this.mIgnoreModifier && this.isMatchingClassName(className)) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "no.abstract.class.modifier", className);
        }
    }

    private boolean isAbstract(DetailAST aAST) {
        DetailAST abstractAST = aAST.findFirstToken(5).findFirstToken(40);
        return abstractAST != null;
    }

    private boolean isMatchingClassName(String aClassName) {
        return this.getRegexp().matcher(aClassName).find();
    }
}

