/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.ConversionException;

public class HiddenFieldCheck
extends Check {
    public static final String MSG_KEY = "hidden.field";
    private FieldFrame currentFrame;
    private Pattern regexp;
    private boolean ignoreSetter;
    private boolean setterCanReturnItsClass;
    private boolean ignoreConstructorParameter;
    private boolean ignoreAbstractMethods;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{10, 21, 14, 154, 155};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{10, 21};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{14, 154, 155};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.currentFrame = new FieldFrame(null, true, null);
    }

    @Override
    public void visitToken(DetailAST ast) {
        int type = ast.getType();
        switch (type) {
            case 10: 
            case 21: {
                this.processVariable(ast);
                break;
            }
            default: {
                this.visitOtherTokens(ast, type);
            }
        }
    }

    private void visitOtherTokens(DetailAST ast, int type) {
        DetailAST typeMods = ast.findFirstToken(5);
        boolean isStaticInnerType = typeMods != null && typeMods.branchContains(64);
        FieldFrame frame = new FieldFrame(this.currentFrame, isStaticInnerType, type == 14 || type == 154 ? ast.findFirstToken(58).getText() : null);
        DetailAST objBlock = ast.findFirstToken(6);
        if (objBlock != null) {
            for (DetailAST child = objBlock.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getType() != 10) continue;
                String name = child.findFirstToken(58).getText();
                DetailAST mods = child.findFirstToken(5);
                if (mods.branchContains(64)) {
                    frame.addStaticField(name);
                    continue;
                }
                frame.addInstanceField(name);
            }
        }
        this.currentFrame = frame;
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (ast.getType() == 14 || ast.getType() == 154 || ast.getType() == 155) {
            this.currentFrame = this.currentFrame.getParent();
        }
    }

    private void processVariable(DetailAST ast) {
        DetailAST nameAST;
        String name;
        if (!(ScopeUtils.inInterfaceOrAnnotationBlock(ast) || !ScopeUtils.isLocalVariableDef(ast) && ast.getType() != 21 || !this.currentFrame.containsStaticField(name = (nameAST = ast.findFirstToken(58)).getText()) && (HiddenFieldCheck.inStatic(ast) || !this.currentFrame.containsInstanceField(name)) || this.regexp != null && this.getRegexp().matcher(name).find() || this.isIgnoredSetterParam(ast, name) || this.isIgnoredConstructorParam(ast) || this.isIgnoredParamOfAbstractMethod(ast))) {
            this.log(nameAST, MSG_KEY, name);
        }
    }

    private static boolean inStatic(DetailAST ast) {
        for (DetailAST parent = ast.getParent(); parent != null; parent = parent.getParent()) {
            switch (parent.getType()) {
                case 12: {
                    return true;
                }
                case 9: {
                    DetailAST mods = parent.findFirstToken(5);
                    return mods.branchContains(64);
                }
            }
        }
        return false;
    }

    private boolean isIgnoredSetterParam(DetailAST ast, String name) {
        if (ast.getType() == 21 && this.ignoreSetter) {
            DetailAST parametersAST = ast.getParent();
            DetailAST methodAST = parametersAST.getParent();
            if (parametersAST.getChildCount() == 1 && methodAST.getType() == 9 && this.isSetterMethod(methodAST, name)) {
                return true;
            }
        }
        return false;
    }

    private boolean isSetterMethod(DetailAST aMethodAST, String aName) {
        String methodName = aMethodAST.findFirstToken(58).getText();
        boolean isSetterMethod = false;
        if (methodName.equals("set" + HiddenFieldCheck.capitalize(aName))) {
            DetailAST typeAST = aMethodAST.findFirstToken(13);
            String returnType = typeAST.getFirstChild().getText();
            if (typeAST.branchContains(49) || this.setterCanReturnItsClass && this.currentFrame.embeddedIn(returnType)) {
                isSetterMethod = true;
            }
        }
        return isSetterMethod;
    }

    private static String capitalize(String name) {
        String setterName = name;
        if (name != null && (name.length() == 1 || name.length() > 1 && !Character.isUpperCase(name.charAt(1)))) {
            setterName = name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
        }
        return setterName;
    }

    private boolean isIgnoredConstructorParam(DetailAST ast) {
        boolean result = false;
        if (ast.getType() == 21 && this.ignoreConstructorParameter) {
            DetailAST parametersAST = ast.getParent();
            DetailAST constructorAST = parametersAST.getParent();
            result = constructorAST.getType() == 8;
        }
        return result;
    }

    private boolean isIgnoredParamOfAbstractMethod(DetailAST ast) {
        DetailAST method;
        boolean result = false;
        if (ast.getType() == 21 && this.ignoreAbstractMethods && (method = ast.getParent().getParent()).getType() == 9) {
            DetailAST mods = method.findFirstToken(5);
            result = mods != null && mods.branchContains(40);
        }
        return result;
    }

    public void setIgnoreFormat(String format) throws ConversionException {
        this.regexp = Utils.createPattern(format);
    }

    public void setIgnoreSetter(boolean ignoreSetter) {
        this.ignoreSetter = ignoreSetter;
    }

    public void setSetterCanReturnItsClass(boolean aSetterCanReturnItsClass) {
        this.setterCanReturnItsClass = aSetterCanReturnItsClass;
    }

    public void setIgnoreConstructorParameter(boolean ignoreConstructorParameter) {
        this.ignoreConstructorParameter = ignoreConstructorParameter;
    }

    public void setIgnoreAbstractMethods(boolean ignoreAbstractMethods) {
        this.ignoreAbstractMethods = ignoreAbstractMethods;
    }

    public Pattern getRegexp() {
        return this.regexp;
    }

    private static class FieldFrame {
        private final String frameName;
        private final boolean staticType;
        private final FieldFrame parent;
        private final Set<String> instanceFields = Sets.newHashSet();
        private final Set<String> staticFields = Sets.newHashSet();

        public FieldFrame(FieldFrame parent, boolean staticType, String frameName) {
            this.parent = parent;
            this.staticType = staticType;
            this.frameName = frameName;
        }

        boolean isStaticType() {
            return this.staticType;
        }

        public void addInstanceField(String field) {
            this.instanceFields.add(field);
        }

        public void addStaticField(String field) {
            this.staticFields.add(field);
        }

        public boolean containsInstanceField(String field) {
            return this.instanceFields.contains(field) || !this.isStaticType() && this.parent != null && this.parent.containsInstanceField(field);
        }

        public boolean containsStaticField(String field) {
            return this.staticFields.contains(field) || this.parent != null && this.parent.containsStaticField(field);
        }

        public FieldFrame getParent() {
            return this.parent;
        }

        private boolean embeddedIn(String classOrEnumName) {
            FieldFrame currentFrame = this;
            while (currentFrame != null) {
                if (Objects.equal((Object)currentFrame.frameName, (Object)classOrEnumName)) {
                    return true;
                }
                currentFrame = currentFrame.parent;
            }
            return false;
        }
    }
}

