/*
 * Decompiled with CFR 0.152.
 */
package com.roncoo.fastdfs;

import com.roncoo.common.IniFileReader;
import com.roncoo.common.MyException;
import com.roncoo.fastdfs.TrackerGroup;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Properties;

public class ClientGlobal {
    public static final String CONF_KEY_CONNECT_TIMEOUT = "connect_timeout";
    public static final String CONF_KEY_NETWORK_TIMEOUT = "network_timeout";
    public static final String CONF_KEY_CHARSET = "charset";
    public static final String CONF_KEY_HTTP_ANTI_STEAL_TOKEN = "http.anti_steal_token";
    public static final String CONF_KEY_HTTP_SECRET_KEY = "http.secret_key";
    public static final String CONF_KEY_HTTP_TRACKER_HTTP_PORT = "http.tracker_http_port";
    public static final String CONF_KEY_TRACKER_SERVER = "tracker_server";
    public static final String PROP_KEY_CONNECT_TIMEOUT_IN_SECONDS = "fastdfs.connect_timeout_in_seconds";
    public static final String PROP_KEY_NETWORK_TIMEOUT_IN_SECONDS = "fastdfs.network_timeout_in_seconds";
    public static final String PROP_KEY_CHARSET = "fastdfs.charset";
    public static final String PROP_KEY_HTTP_ANTI_STEAL_TOKEN = "fastdfs.http_anti_steal_token";
    public static final String PROP_KEY_HTTP_SECRET_KEY = "fastdfs.http_secret_key";
    public static final String PROP_KEY_HTTP_TRACKER_HTTP_PORT = "fastdfs.http_tracker_http_port";
    public static final String PROP_KEY_TRACKER_SERVERS = "fastdfs.tracker_servers";
    public static final String PROP_KEY_CONNECTION_POOL_ENABLED = "fastdfs.connection_pool.enabled";
    public static final String PROP_KEY_CONNECTION_POOL_MAX_COUNT_PER_ENTRY = "fastdfs.connection_pool.max_count_per_entry";
    public static final String PROP_KEY_CONNECTION_POOL_MAX_IDLE_TIME = "fastdfs.connection_pool.max_idle_time";
    public static final String PROP_KEY_CONNECTION_POOL_MAX_WAIT_TIME_IN_MS = "fastdfs.connection_pool.max_wait_time_in_ms";
    public static final int DEFAULT_CONNECT_TIMEOUT = 5;
    public static final int DEFAULT_NETWORK_TIMEOUT = 30;
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final boolean DEFAULT_HTTP_ANTI_STEAL_TOKEN = false;
    public static final String DEFAULT_HTTP_SECRET_KEY = "FastDFS1234567890";
    public static final int DEFAULT_HTTP_TRACKER_HTTP_PORT = 80;
    public static final boolean DEFAULT_CONNECTION_POOL_ENABLED = true;
    public static final int DEFAULT_CONNECTION_POOL_MAX_COUNT_PER_ENTRY = 100;
    public static final int DEFAULT_CONNECTION_POOL_MAX_IDLE_TIME = 3600;
    public static final int DEFAULT_CONNECTION_POOL_MAX_WAIT_TIME_IN_MS = 1000;
    public static int g_connect_timeout = 5000;
    public static int g_network_timeout = 30000;
    public static String g_charset = "UTF-8";
    public static boolean g_anti_steal_token = false;
    public static String g_secret_key = "FastDFS1234567890";
    public static int g_tracker_http_port = 80;
    public static boolean g_connection_pool_enabled = true;
    public static int g_connection_pool_max_count_per_entry = 100;
    public static int g_connection_pool_max_idle_time = 3600000;
    public static int g_connection_pool_max_wait_time_in_ms = 1000;
    public static TrackerGroup g_tracker_group;

    private ClientGlobal() {
    }

    public static void init(String conf_filename) throws IOException, MyException {
        String[] szTrackerServers;
        IniFileReader iniReader = new IniFileReader(conf_filename);
        g_connect_timeout = iniReader.getIntValue(CONF_KEY_CONNECT_TIMEOUT, 5);
        if (g_connect_timeout < 0) {
            g_connect_timeout = 5;
        }
        g_connect_timeout *= 1000;
        g_network_timeout = iniReader.getIntValue(CONF_KEY_NETWORK_TIMEOUT, 30);
        if (g_network_timeout < 0) {
            g_network_timeout = 30;
        }
        g_network_timeout *= 1000;
        g_charset = iniReader.getStrValue(CONF_KEY_CHARSET);
        if (g_charset == null || g_charset.length() == 0) {
            g_charset = "ISO8859-1";
        }
        if ((szTrackerServers = iniReader.getValues(CONF_KEY_TRACKER_SERVER)) == null) {
            throw new MyException("item \"tracker_server\" in " + conf_filename + " not found");
        }
        InetSocketAddress[] tracker_servers = new InetSocketAddress[szTrackerServers.length];
        for (int i = 0; i < szTrackerServers.length; ++i) {
            String[] parts = szTrackerServers[i].split("\\:", 2);
            if (parts.length != 2) {
                throw new MyException("the value of item \"tracker_server\" is invalid, the correct format is host:port");
            }
            tracker_servers[i] = new InetSocketAddress(parts[0].trim(), Integer.parseInt(parts[1].trim()));
        }
        g_tracker_group = new TrackerGroup(tracker_servers);
        g_tracker_http_port = iniReader.getIntValue(CONF_KEY_HTTP_TRACKER_HTTP_PORT, 80);
        g_anti_steal_token = iniReader.getBoolValue(CONF_KEY_HTTP_ANTI_STEAL_TOKEN, false);
        if (g_anti_steal_token) {
            g_secret_key = iniReader.getStrValue(CONF_KEY_HTTP_SECRET_KEY);
        }
        g_connection_pool_enabled = iniReader.getBoolValue("connection_pool.enabled", true);
        g_connection_pool_max_count_per_entry = iniReader.getIntValue("connection_pool.max_count_per_entry", 100);
        g_connection_pool_max_idle_time = iniReader.getIntValue("connection_pool.max_idle_time", 3600);
        if (g_connection_pool_max_idle_time < 0) {
            g_connection_pool_max_idle_time = 3600;
        }
        g_connection_pool_max_idle_time *= 1000;
        g_connection_pool_max_wait_time_in_ms = iniReader.getIntValue("connection_pool.max_wait_time_in_ms", 1000);
        if (g_connection_pool_max_wait_time_in_ms < 0) {
            g_connection_pool_max_wait_time_in_ms = 1000;
        }
    }

    public static void initByProperties(String propsFilePath) throws IOException, MyException {
        Properties props = new Properties();
        InputStream in = IniFileReader.loadFromOsFileSystemOrClasspathAsStream(propsFilePath);
        if (in != null) {
            props.load(in);
        }
        ClientGlobal.initByProperties(props);
    }

    public static void initByProperties(Properties props) throws IOException, MyException {
        String trackerServersConf = props.getProperty(PROP_KEY_TRACKER_SERVERS);
        if (trackerServersConf == null || trackerServersConf.trim().length() == 0) {
            throw new MyException(String.format("configure item %s is required", PROP_KEY_TRACKER_SERVERS));
        }
        ClientGlobal.initByTrackers(trackerServersConf.trim());
        String connectTimeoutInSecondsConf = props.getProperty(PROP_KEY_CONNECT_TIMEOUT_IN_SECONDS);
        String networkTimeoutInSecondsConf = props.getProperty(PROP_KEY_NETWORK_TIMEOUT_IN_SECONDS);
        String charsetConf = props.getProperty(PROP_KEY_CHARSET);
        String httpAntiStealTokenConf = props.getProperty(PROP_KEY_HTTP_ANTI_STEAL_TOKEN);
        String httpSecretKeyConf = props.getProperty(PROP_KEY_HTTP_SECRET_KEY);
        String httpTrackerHttpPortConf = props.getProperty(PROP_KEY_HTTP_TRACKER_HTTP_PORT);
        String poolEnabled = props.getProperty(PROP_KEY_CONNECTION_POOL_ENABLED);
        String poolMaxCountPerEntry = props.getProperty(PROP_KEY_CONNECTION_POOL_MAX_COUNT_PER_ENTRY);
        String poolMaxIdleTime = props.getProperty(PROP_KEY_CONNECTION_POOL_MAX_IDLE_TIME);
        String poolMaxWaitTimeInMS = props.getProperty(PROP_KEY_CONNECTION_POOL_MAX_WAIT_TIME_IN_MS);
        if (connectTimeoutInSecondsConf != null && connectTimeoutInSecondsConf.trim().length() != 0) {
            g_connect_timeout = Integer.parseInt(connectTimeoutInSecondsConf.trim()) * 1000;
        }
        if (networkTimeoutInSecondsConf != null && networkTimeoutInSecondsConf.trim().length() != 0) {
            g_network_timeout = Integer.parseInt(networkTimeoutInSecondsConf.trim()) * 1000;
        }
        if (charsetConf != null && charsetConf.trim().length() != 0) {
            g_charset = charsetConf.trim();
        }
        if (httpAntiStealTokenConf != null && httpAntiStealTokenConf.trim().length() != 0) {
            g_anti_steal_token = Boolean.parseBoolean(httpAntiStealTokenConf);
        }
        if (httpSecretKeyConf != null && httpSecretKeyConf.trim().length() != 0) {
            g_secret_key = httpSecretKeyConf.trim();
        }
        if (httpTrackerHttpPortConf != null && httpTrackerHttpPortConf.trim().length() != 0) {
            g_tracker_http_port = Integer.parseInt(httpTrackerHttpPortConf);
        }
        if (poolEnabled != null && poolEnabled.trim().length() != 0) {
            g_connection_pool_enabled = Boolean.parseBoolean(poolEnabled);
        }
        if (poolMaxCountPerEntry != null && poolMaxCountPerEntry.trim().length() != 0) {
            g_connection_pool_max_count_per_entry = Integer.parseInt(poolMaxCountPerEntry);
        }
        if (poolMaxIdleTime != null && poolMaxIdleTime.trim().length() != 0) {
            g_connection_pool_max_idle_time = Integer.parseInt(poolMaxIdleTime) * 1000;
        }
        if (poolMaxWaitTimeInMS != null && poolMaxWaitTimeInMS.trim().length() != 0) {
            g_connection_pool_max_wait_time_in_ms = Integer.parseInt(poolMaxWaitTimeInMS);
        }
    }

    public static void initByTrackers(String trackerServers) throws IOException, MyException {
        String[] arr1;
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>();
        String spr1 = ",";
        String spr2 = ":";
        for (String addrStr : arr1 = trackerServers.trim().split(spr1)) {
            String[] arr2 = addrStr.trim().split(spr2);
            String host = arr2[0].trim();
            int port = Integer.parseInt(arr2[1].trim());
            list.add(new InetSocketAddress(host, port));
        }
        InetSocketAddress[] trackerAddresses = list.toArray(new InetSocketAddress[list.size()]);
        ClientGlobal.initByTrackers(trackerAddresses);
    }

    public static void initByTrackers(InetSocketAddress[] trackerAddresses) throws IOException, MyException {
        g_tracker_group = new TrackerGroup(trackerAddresses);
    }

    public static Socket getSocket(String ip_addr, int port) throws IOException {
        Socket sock = new Socket();
        sock.setSoTimeout(g_network_timeout);
        sock.connect(new InetSocketAddress(ip_addr, port), g_connect_timeout);
        return sock;
    }

    public static Socket getSocket(InetSocketAddress addr) throws IOException {
        Socket sock = new Socket();
        sock.setReuseAddress(true);
        sock.setSoTimeout(g_network_timeout);
        sock.connect(addr, g_connect_timeout);
        return sock;
    }

    public static int getG_connect_timeout() {
        return g_connect_timeout;
    }

    public static void setG_connect_timeout(int connect_timeout) {
        g_connect_timeout = connect_timeout;
    }

    public static int getG_network_timeout() {
        return g_network_timeout;
    }

    public static void setG_network_timeout(int network_timeout) {
        g_network_timeout = network_timeout;
    }

    public static String getG_charset() {
        return g_charset;
    }

    public static void setG_charset(String charset) {
        g_charset = charset;
    }

    public static int getG_tracker_http_port() {
        return g_tracker_http_port;
    }

    public static void setG_tracker_http_port(int tracker_http_port) {
        g_tracker_http_port = tracker_http_port;
    }

    public static boolean getG_anti_steal_token() {
        return g_anti_steal_token;
    }

    public static boolean isG_anti_steal_token() {
        return g_anti_steal_token;
    }

    public static void setG_anti_steal_token(boolean anti_steal_token) {
        g_anti_steal_token = anti_steal_token;
    }

    public static String getG_secret_key() {
        return g_secret_key;
    }

    public static void setG_secret_key(String secret_key) {
        g_secret_key = secret_key;
    }

    public static TrackerGroup getG_tracker_group() {
        return g_tracker_group;
    }

    public static void setG_tracker_group(TrackerGroup tracker_group) {
        g_tracker_group = tracker_group;
    }

    public static boolean isG_connection_pool_enabled() {
        return g_connection_pool_enabled;
    }

    public static String configInfo() {
        String trackerServers = "";
        if (g_tracker_group != null) {
            InetSocketAddress[] trackerAddresses;
            for (InetSocketAddress inetSocketAddress : trackerAddresses = ClientGlobal.g_tracker_group.tracker_servers) {
                if (trackerServers.length() > 0) {
                    trackerServers = trackerServers + ",";
                }
                trackerServers = trackerServers + inetSocketAddress.toString().substring(1);
            }
        }
        return "{\n  g_connect_timeout(ms) = " + g_connect_timeout + "\n  g_network_timeout(ms) = " + g_network_timeout + "\n  g_charset = " + g_charset + "\n  g_anti_steal_token = " + g_anti_steal_token + "\n  g_secret_key = " + g_secret_key + "\n  g_tracker_http_port = " + g_tracker_http_port + "\n  g_connection_pool_enabled = " + g_connection_pool_enabled + "\n  g_connection_pool_max_count_per_entry = " + g_connection_pool_max_count_per_entry + "\n  g_connection_pool_max_idle_time(ms) = " + g_connection_pool_max_idle_time + "\n  g_connection_pool_max_wait_time_in_ms(ms) = " + g_connection_pool_max_wait_time_in_ms + "\n  trackerServers = " + trackerServers + "\n}";
    }
}

