/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.interceptor;

import com.google.common.base.Preconditions;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.ForwardingClientCall;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class DefaultDeadlineInterceptor
implements ClientInterceptor {
    private Duration duration;

    public DefaultDeadlineInterceptor(Duration duration) {
        Preconditions.checkNotNull((Object)duration, (Object)"duration");
        Preconditions.checkArgument((!duration.isNegative() ? 1 : 0) != 0, (Object)"duration must be greater than zero");
        this.duration = duration;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        if (callOptions.getDeadline() == null && Context.current().getDeadline() == null) {
            callOptions = callOptions.withDeadlineAfter(this.duration.toMillis(), TimeUnit.MILLISECONDS);
        }
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){};
    }
}

