/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk;

import com.sensorsdata.analytics.javasdk.ISensorsAnalytics;
import com.sensorsdata.analytics.javasdk.bean.EventRecord;
import com.sensorsdata.analytics.javasdk.bean.ItemRecord;
import com.sensorsdata.analytics.javasdk.bean.SuperPropertiesRecord;
import com.sensorsdata.analytics.javasdk.bean.UserRecord;
import com.sensorsdata.analytics.javasdk.consumer.Consumer;
import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class SensorsAnalytics
implements ISensorsAnalytics {
    private final Consumer consumer;
    private final Map<String, Object> superProperties;
    private boolean enableTimeFree = false;

    public SensorsAnalytics(Consumer consumer) {
        this.consumer = consumer;
        this.superProperties = new ConcurrentHashMap<String, Object>();
        this.clearSuperProperties();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                SensorsAnalytics.this.flush();
            }
        }));
    }

    public boolean isEnableTimeFree() {
        return this.enableTimeFree;
    }

    @Override
    public void setEnableTimeFree(boolean enableTimeFree) {
        this.enableTimeFree = enableTimeFree;
    }

    @Override
    public void registerSuperProperties(SuperPropertiesRecord propertiesRecord) {
        for (String key : propertiesRecord.getPropertyMap().keySet()) {
            this.superProperties.put(key, propertiesRecord.getPropertyMap().get(key));
        }
    }

    @Override
    public void registerSuperProperties(Map<String, Object> superPropertiesMap) {
        for (Map.Entry<String, Object> item : superPropertiesMap.entrySet()) {
            this.superProperties.put(item.getKey(), item.getValue());
        }
    }

    @Override
    public void clearSuperProperties() {
        this.superProperties.clear();
        this.superProperties.put("$lib", "Java");
        this.superProperties.put("$lib_version", "3.2.0");
    }

    @Override
    public void track(EventRecord eventRecord) throws InvalidArgumentException {
        this.addEvent(eventRecord.getDistinctId(), eventRecord.getIsLoginId(), null, "track", eventRecord.getEventName(), eventRecord.getPropertyMap());
    }

    @Override
    public void profileSet(UserRecord userRecord) throws InvalidArgumentException {
        this.dealProfile(userRecord, "profile_set");
    }

    @Override
    public void profileSetOnce(UserRecord userRecord) throws InvalidArgumentException {
        this.dealProfile(userRecord, "profile_set_once");
    }

    @Override
    public void profileAppend(UserRecord userRecord) throws InvalidArgumentException {
        this.dealProfile(userRecord, "profile_append");
    }

    @Override
    public void profileIncrement(UserRecord userRecord) throws InvalidArgumentException {
        this.dealProfile(userRecord, "profile_increment");
    }

    @Override
    public void profileUnset(UserRecord userRecord) throws InvalidArgumentException {
        this.dealProfile(userRecord, "profile_unset");
    }

    @Override
    public void profileDelete(UserRecord userRecord) throws InvalidArgumentException {
        this.dealProfile(userRecord, "profile_delete");
    }

    @Override
    public void itemSet(ItemRecord itemRecord) throws InvalidArgumentException {
        this.addItem(itemRecord.getItemType(), itemRecord.getItemId(), "item_set", itemRecord.getPropertyMap());
    }

    @Override
    public void itemDelete(ItemRecord itemRecord) throws InvalidArgumentException {
        this.addItem(itemRecord.getItemType(), itemRecord.getItemId(), "item_delete", itemRecord.getPropertyMap());
    }

    private void dealProfile(UserRecord userRecord, String actionType) throws InvalidArgumentException {
        this.addEvent(userRecord.getDistinctId(), userRecord.getIsLoginId(), null, actionType, null, userRecord.getPropertyMap());
    }

    @Override
    public void track(String distinctId, boolean isLoginId, String eventName) throws InvalidArgumentException {
        this.addEvent(distinctId, isLoginId, null, "track", eventName, null);
    }

    @Override
    public void track(String distinctId, boolean isLoginId, String eventName, Map<String, Object> properties) throws InvalidArgumentException {
        this.addEvent(distinctId, isLoginId, null, "track", eventName, properties);
    }

    @Override
    public void trackSignUp(String loginId, String anonymousId) throws InvalidArgumentException {
        this.addEvent(loginId, false, anonymousId, "track_signup", "$SignUp", null);
    }

    @Override
    public void trackSignUp(String loginId, String anonymousId, Map<String, Object> properties) throws InvalidArgumentException {
        this.addEvent(loginId, false, anonymousId, "track_signup", "$SignUp", properties);
    }

    @Override
    public void profileSet(String distinctId, boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        this.addEvent(distinctId, isLoginId, null, "profile_set", null, properties);
    }

    @Override
    public void profileSet(String distinctId, boolean isLoginId, String property, Object value) throws InvalidArgumentException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        this.addEvent(distinctId, isLoginId, null, "profile_set", null, properties);
    }

    @Override
    public void profileSetOnce(String distinctId, boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        this.addEvent(distinctId, isLoginId, null, "profile_set_once", null, properties);
    }

    @Override
    public void profileSetOnce(String distinctId, boolean isLoginId, String property, Object value) throws InvalidArgumentException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        this.addEvent(distinctId, isLoginId, null, "profile_set_once", null, properties);
    }

    @Override
    public void profileIncrement(String distinctId, boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        this.addEvent(distinctId, isLoginId, null, "profile_increment", null, properties);
    }

    @Override
    public void profileIncrement(String distinctId, boolean isLoginId, String property, long value) throws InvalidArgumentException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        this.addEvent(distinctId, isLoginId, null, "profile_increment", null, properties);
    }

    @Override
    public void profileAppend(String distinctId, boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        this.addEvent(distinctId, isLoginId, null, "profile_append", null, properties);
    }

    @Override
    public void profileAppend(String distinctId, boolean isLoginId, String property, String value) throws InvalidArgumentException {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, values);
        this.addEvent(distinctId, isLoginId, null, "profile_append", null, properties);
    }

    @Override
    public void profileUnset(String distinctId, boolean isLoginId, String property) throws InvalidArgumentException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, true);
        this.addEvent(distinctId, isLoginId, null, "profile_unset", null, properties);
    }

    @Override
    public void profileUnset(String distinctId, boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            boolean value;
            if ("$project".equals(property.getKey()) || property.getValue() instanceof Boolean && (value = ((Boolean)property.getValue()).booleanValue())) continue;
            throw new InvalidArgumentException("The property value of " + property.getKey() + " should be true.");
        }
        this.addEvent(distinctId, isLoginId, null, "profile_unset", null, properties);
    }

    @Override
    public void profileDelete(String distinctId, boolean isLoginId) throws InvalidArgumentException {
        this.addEvent(distinctId, isLoginId, null, "profile_delete", null, new HashMap<String, Object>());
    }

    @Override
    public void itemSet(String itemType, String itemId, Map<String, Object> properties) throws InvalidArgumentException {
        this.addItem(itemType, itemId, "item_set", properties);
    }

    @Override
    public void itemDelete(String itemType, String itemId, Map<String, Object> properties) throws InvalidArgumentException {
        this.addItem(itemType, itemId, "item_delete", properties);
    }

    @Override
    public void flush() {
        this.consumer.flush();
    }

    @Override
    public void shutdown() {
        this.consumer.close();
    }

    private void addEvent(String distinctId, boolean isLoginId, String originDistinctId, String actionType, String eventName, Map<String, Object> properties) throws InvalidArgumentException {
        SensorsAnalyticsUtil.assertValue("Distinct Id", distinctId);
        SensorsAnalyticsUtil.assertProperties(actionType, properties);
        if (actionType.equals("track")) {
            SensorsAnalyticsUtil.assertKey("Event Name", eventName);
        } else if (actionType.equals("track_signup")) {
            SensorsAnalyticsUtil.assertValue("Original Distinct Id", originDistinctId);
        }
        long time = System.currentTimeMillis();
        HashMap<String, Object> newProperties = null;
        if (properties != null) {
            newProperties = new HashMap<String, Object>(properties);
        }
        if (newProperties != null && newProperties.containsKey("$time")) {
            Date eventTime = (Date)newProperties.get("$time");
            newProperties.remove("$time");
            time = eventTime.getTime();
        }
        String eventProject = null;
        String eventToken = null;
        if (newProperties != null) {
            if (newProperties.containsKey("$project")) {
                eventProject = (String)newProperties.get("$project");
                newProperties.remove("$project");
            }
            if (newProperties.containsKey("$token")) {
                eventToken = (String)newProperties.get("$token");
                newProperties.remove("$token");
            }
        }
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        if (actionType.equals("track") || actionType.equals("track_signup")) {
            eventProperties.putAll(this.superProperties);
        }
        if (newProperties != null) {
            eventProperties.putAll(newProperties);
        }
        if (isLoginId) {
            eventProperties.put("$is_login_id", true);
        }
        Map<String, String> libProperties = this.getLibProperties();
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("type", actionType);
        event.put("time", time);
        event.put("distinct_id", distinctId);
        event.put("properties", eventProperties);
        event.put("lib", libProperties);
        event.put("_track_id", new Random().nextInt());
        if (eventProject != null) {
            event.put("project", eventProject);
        }
        if (eventToken != null) {
            event.put("token", eventToken);
        }
        if (this.enableTimeFree) {
            event.put("time_free", true);
        }
        if (actionType.equals("track")) {
            event.put("event", eventName);
        } else if (actionType.equals("track_signup")) {
            event.put("event", eventName);
            event.put("original_id", originDistinctId);
        }
        this.consumer.send(event);
    }

    private void addItem(String itemType, String itemId, String actionType, Map<String, Object> properties) throws InvalidArgumentException {
        SensorsAnalyticsUtil.assertKey("Item Type", itemType);
        SensorsAnalyticsUtil.assertValue("Item Id", itemId);
        SensorsAnalyticsUtil.assertProperties(actionType, properties);
        HashMap<String, Object> newProperties = null;
        if (properties != null) {
            newProperties = new HashMap<String, Object>(properties);
        }
        String eventProject = null;
        String eventToken = null;
        if (newProperties != null) {
            if (newProperties.containsKey("$project")) {
                eventProject = (String)newProperties.get("$project");
                newProperties.remove("$project");
            }
            if (newProperties.containsKey("$token")) {
                eventToken = (String)newProperties.get("$token");
                newProperties.remove("$token");
            }
        }
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        if (newProperties != null) {
            eventProperties.putAll(newProperties);
        }
        Map<String, String> libProperties = this.getLibProperties();
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("type", actionType);
        record.put("time", System.currentTimeMillis());
        record.put("properties", eventProperties);
        record.put("lib", libProperties);
        if (eventProject != null) {
            record.put("project", eventProject);
        }
        if (eventToken != null) {
            record.put("token", eventToken);
        }
        record.put("item_type", itemType);
        record.put("item_id", itemId);
        this.consumer.send(record);
    }

    private Map<String, String> getLibProperties() {
        StackTraceElement[] trace;
        HashMap<String, String> libProperties = new HashMap<String, String>();
        libProperties.put("$lib", "Java");
        libProperties.put("$lib_version", "3.2.0");
        libProperties.put("$lib_method", "code");
        if (this.superProperties.containsKey("$app_version")) {
            libProperties.put("$app_version", (String)this.superProperties.get("$app_version"));
        }
        if ((trace = new Exception().getStackTrace()).length > 3) {
            StackTraceElement traceElement = trace[3];
            libProperties.put("$lib_detail", String.format("%s##%s##%s##%s", traceElement.getClassName(), traceElement.getMethodName(), traceElement.getFileName(), traceElement.getLineNumber()));
        }
        return libProperties;
    }
}

