/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.bean;

import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SuperPropertiesRecord
implements Serializable {
    private static final long serialVersionUID = 6526668600748384833L;
    private final Map<String, Object> propertyMap;

    private SuperPropertiesRecord(Map<String, Object> propertyMap) {
        this.propertyMap = propertyMap;
    }

    public Map<String, Object> getPropertyMap() {
        return this.propertyMap;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, Object> propertyMap = new HashMap<String, Object>();

        private Builder() {
        }

        public SuperPropertiesRecord build() throws InvalidArgumentException {
            if (this.propertyMap.size() == 0) {
                throw new InvalidArgumentException("The propertyMap is empty.");
            }
            return new SuperPropertiesRecord(this.propertyMap);
        }

        public Builder addProperties(Map<String, Object> properties) {
            if (properties != null) {
                this.propertyMap.putAll(properties);
            }
            return this;
        }

        public Builder addProperty(String key, String property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, boolean property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, Number property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, Date property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, List<String> property) {
            this.addPropertyObject(key, property);
            return this;
        }

        private void addPropertyObject(String key, Object property) {
            if (key != null) {
                this.propertyMap.put(key, property);
            }
        }
    }
}

