/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.consumer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sensorsdata.analytics.javasdk.consumer.Consumer;
import com.sensorsdata.analytics.javasdk.consumer.HttpConsumer;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BatchConsumer
implements Consumer {
    private static final int MAX_FLUSH_BULK_SIZE = 1000;
    private static final int MAX_CACHE_SIZE = 6000;
    private static final int MIN_CACHE_SIZE = 3000;
    private final List<Map<String, Object>> messageList = new LinkedList<Map<String, Object>>();
    private final HttpConsumer httpConsumer;
    private final ObjectMapper jsonMapper;
    private final int bulkSize;
    private final boolean throwException;
    private final int maxCacheSize;

    public BatchConsumer(String serverUrl) {
        this(serverUrl, 50);
    }

    public BatchConsumer(String serverUrl, int bulkSize) {
        this(serverUrl, bulkSize, false);
    }

    public BatchConsumer(String serverUrl, int bulkSize, boolean throwException) {
        this(serverUrl, bulkSize, 0, throwException);
    }

    public BatchConsumer(String serverUrl, int bulkSize, int maxCacheSize, boolean throwException) {
        this.httpConsumer = new HttpConsumer(serverUrl, null);
        this.jsonMapper = SensorsAnalyticsUtil.getJsonObjectMapper();
        this.bulkSize = Math.min(1000, bulkSize);
        this.maxCacheSize = maxCacheSize > 6000 ? 6000 : (maxCacheSize > 0 && maxCacheSize < 3000 ? 3000 : maxCacheSize);
        this.throwException = throwException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Map<String, Object> message) {
        List<Map<String, Object>> list = this.messageList;
        synchronized (list) {
            int size = this.messageList.size();
            if (this.maxCacheSize <= 0 || size < this.maxCacheSize) {
                this.messageList.add(message);
                ++size;
            }
            if (size >= this.bulkSize) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        List<Map<String, Object>> list = this.messageList;
        synchronized (list) {
            while (!this.messageList.isEmpty()) {
                String sendingData = null;
                List<Map<String, Object>> sendList = this.messageList.subList(0, Math.min(this.bulkSize, this.messageList.size()));
                try {
                    sendingData = this.jsonMapper.writeValueAsString(sendList);
                }
                catch (JsonProcessingException e) {
                    sendList.clear();
                    if (!this.throwException) continue;
                    throw new RuntimeException("Failed to serialize data.", e);
                }
                try {
                    this.httpConsumer.consume(sendingData);
                    sendList.clear();
                }
                catch (Exception e) {
                    if (this.throwException) {
                        throw new RuntimeException("Failed to dump message with BatchConsumer.", e);
                    }
                    return;
                }
            }
        }
    }

    @Override
    public void close() {
        this.flush();
        this.httpConsumer.close();
    }
}

