/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.consumer;

import com.sensorsdata.analytics.javasdk.consumer.InnerLoggingConsumer;
import com.sensorsdata.analytics.javasdk.consumer.LoggingFileWriter;
import com.sensorsdata.analytics.javasdk.consumer.LoggingFileWriterFactory;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Map;

public class ConcurrentLoggingConsumer
extends InnerLoggingConsumer {
    public ConcurrentLoggingConsumer(String filenamePrefix) throws IOException {
        this(filenamePrefix, null);
    }

    public ConcurrentLoggingConsumer(String filenamePrefix, int bufferSize) throws IOException {
        this(filenamePrefix, null, bufferSize);
    }

    public ConcurrentLoggingConsumer(String filenamePrefix, String lockFileName) throws IOException {
        this(filenamePrefix, lockFileName, 8192);
    }

    public ConcurrentLoggingConsumer(String filenamePrefix, String lockFileName, int bufferSize) throws IOException {
        this(filenamePrefix, lockFileName, bufferSize, InnerLoggingConsumer.LogSplitMode.DAY);
    }

    public ConcurrentLoggingConsumer(String filenamePrefix, String lockFileName, int bufferSize, InnerLoggingConsumer.LogSplitMode splitMode) throws IOException {
        super(new InnerLoggingFileWriterFactory(lockFileName), filenamePrefix, bufferSize, splitMode);
    }

    static class InnerLoggingFileWriter
    implements LoggingFileWriter {
        private final Object fileLock = new Object();
        private final String fileName;
        private final String lockFileName;
        private FileOutputStream outputStream;
        private FileOutputStream lockStream;
        private int refCount;
        private static final Map<String, InnerLoggingFileWriter> instances = new HashMap<String, InnerLoggingFileWriter>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static InnerLoggingFileWriter getInstance(String fileName, String lockFileName) throws FileNotFoundException {
            Map<String, InnerLoggingFileWriter> map = instances;
            synchronized (map) {
                if (!instances.containsKey(fileName)) {
                    instances.put(fileName, new InnerLoggingFileWriter(fileName, lockFileName));
                }
                InnerLoggingFileWriter writer = instances.get(fileName);
                ++writer.refCount;
                return writer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void removeInstance(InnerLoggingFileWriter writer) {
            Map<String, InnerLoggingFileWriter> map = instances;
            synchronized (map) {
                --writer.refCount;
                if (writer.refCount == 0) {
                    writer.close();
                    instances.remove(writer.fileName);
                }
            }
        }

        private InnerLoggingFileWriter(String fileName, String lockFileName) throws FileNotFoundException {
            this.fileName = fileName;
            this.lockFileName = lockFileName;
            this.refCount = 0;
            this.initLock();
        }

        @Override
        public void close() {
            try {
                this.outputStream.close();
            }
            catch (Exception e) {
                throw new RuntimeException("fail to close output stream.", e);
            }
        }

        @Override
        public boolean isValid(String fileName) {
            return this.fileName.equals(fileName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean write(StringBuilder sb) {
            Object object = this.fileLock;
            synchronized (object) {
                FileLock lock = null;
                try {
                    FileChannel channel = this.lockStream.getChannel();
                    if (!channel.isOpen()) {
                        this.lockStream.close();
                        this.outputStream.close();
                        this.initLock();
                    }
                    lock = channel.lock(0L, Long.MAX_VALUE, false);
                    this.outputStream.write(sb.toString().getBytes("UTF-8"));
                }
                catch (Exception e) {
                    throw new RuntimeException("fail to write file.", e);
                }
                finally {
                    if (lock != null) {
                        try {
                            lock.release();
                        }
                        catch (IOException e) {
                            throw new RuntimeException("fail to release file lock.", e);
                        }
                    }
                }
            }
            return true;
        }

        private void initLock() throws FileNotFoundException {
            this.outputStream = new FileOutputStream(this.fileName, true);
            this.lockStream = this.lockFileName != null ? new FileOutputStream(this.lockFileName, true) : this.outputStream;
        }
    }

    static class InnerLoggingFileWriterFactory
    implements LoggingFileWriterFactory {
        private String lockFileName;

        InnerLoggingFileWriterFactory(String lockFileName) {
            this.lockFileName = lockFileName;
        }

        @Override
        public LoggingFileWriter getFileWriter(String fileName, String scheduleFileName) throws FileNotFoundException {
            return InnerLoggingFileWriter.getInstance(scheduleFileName, this.lockFileName);
        }

        @Override
        public void closeFileWriter(LoggingFileWriter writer) {
            InnerLoggingFileWriter.removeInstance((InnerLoggingFileWriter)writer);
        }
    }
}

