/*
 * Decompiled with CFR 0.152.
 */
package com.spring4all.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.spring4all.mongodb.MongoOptionProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MongoClient.class})
@EnableConfigurationProperties(value={MongoOptionProperties.class})
@ConditionalOnMissingBean(type={"org.springframework.data.mongodb.MongoDbFactory"})
public class MongoPlusAutoConfiguration {
    @Bean
    public MongoClientOptions mongoClientOptions(MongoOptionProperties mongoOptionProperties) {
        if (mongoOptionProperties == null) {
            return new MongoClientOptions.Builder().build();
        }
        return new MongoClientOptions.Builder().minConnectionsPerHost(mongoOptionProperties.getMinConnectionPerHost().intValue()).connectionsPerHost(mongoOptionProperties.getMaxConnectionPerHost().intValue()).threadsAllowedToBlockForConnectionMultiplier(mongoOptionProperties.getThreadsAllowedToBlockForConnectionMultiplier().intValue()).serverSelectionTimeout(mongoOptionProperties.getServerSelectionTimeout().intValue()).maxWaitTime(mongoOptionProperties.getMaxWaitTime().intValue()).maxConnectionIdleTime(mongoOptionProperties.getMaxConnectionIdleTime().intValue()).maxConnectionLifeTime(mongoOptionProperties.getMaxConnectionLifeTime().intValue()).connectTimeout(mongoOptionProperties.getConnectTimeout().intValue()).socketTimeout(mongoOptionProperties.getSocketTimeout().intValue()).socketKeepAlive(mongoOptionProperties.getSocketKeepAlive().booleanValue()).sslEnabled(mongoOptionProperties.getSslEnabled().booleanValue()).sslInvalidHostNameAllowed(mongoOptionProperties.getSslInvalidHostNameAllowed().booleanValue()).alwaysUseMBeans(mongoOptionProperties.getAlwaysUseMBeans().booleanValue()).heartbeatFrequency(mongoOptionProperties.getHeartbeatFrequency().intValue()).minConnectionsPerHost(mongoOptionProperties.getMinConnectionPerHost().intValue()).heartbeatConnectTimeout(mongoOptionProperties.getHeartbeatConnectTimeout().intValue()).heartbeatSocketTimeout(mongoOptionProperties.getSocketTimeout().intValue()).localThreshold(mongoOptionProperties.getLocalThreshold().intValue()).build();
    }
}

