/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.middleware.logger.support;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AsyncAppenderBase;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import com.taobao.middleware.logger.support.AppenderInfo;
import com.taobao.middleware.logger.support.LogLog;
import com.taobao.middleware.logger.support.LoggerInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class LogbackHelper {
    private static boolean Logback = false;
    private static Field f;
    private static Field f1;
    private static ILoggerFactory lcObject;

    public static Boolean setDepth(int depth) {
        if (Logback) {
            if (depth == -1) {
                depth = Integer.MAX_VALUE;
            }
            try {
                LoggerContext loggerContext = (LoggerContext)lcObject;
                List loggers = loggerContext.getLoggerList();
                for (Logger logger : loggers) {
                    Iterator iter = logger.iteratorForAppenders();
                    LogbackHelper.doSetDepth(iter, depth);
                }
            }
            catch (Throwable t) {
                LogLog.error((String)"failed to set depth for logback", (Throwable)t);
                return false;
            }
            LogLog.info((String)("set logback throwable depth success, depth: " + depth));
            return true;
        }
        return null;
    }

    public static Boolean changeLevel(String name, String level) {
        if (Logback) {
            try {
                Level l = Level.toLevel((String)level, (Level)Level.ERROR);
                LoggerContext loggerContext = (LoggerContext)lcObject;
                Logger logger = loggerContext.exists(name);
                if (logger != null) {
                    logger.setLevel(l);
                    LogLog.info((String)("set logback log level success, " + name + ": " + l));
                    return true;
                }
                LogLog.info((String)("set logback log level fail, no logger name exists: " + name));
            }
            catch (Throwable t) {
                LogLog.error((String)("failed to change level for logback, " + name + ": " + level), (Throwable)t);
            }
            return false;
        }
        return null;
    }

    public static Map<String, LoggerInfo> getLoggers(String name) {
        HashMap<String, LoggerInfo> appenders = new HashMap<String, LoggerInfo>();
        if (Logback) {
            LoggerContext loggerContext = (LoggerContext)lcObject;
            if (name != null && !"".equals(name.trim())) {
                Logger logger = loggerContext.exists(name);
                if (logger != null) {
                    appenders.put(name, LogbackHelper.doGetLoggerInfo(logger));
                }
            } else {
                List loggers = loggerContext.getLoggerList();
                for (Logger logger : loggers) {
                    LoggerInfo info = LogbackHelper.doGetLoggerInfo(logger);
                    if (info.getAppenders() != null && info.getAppenders().isEmpty()) continue;
                    appenders.put(logger.getName(), info);
                }
            }
        }
        return appenders;
    }

    private static void doSetDepth(Iterator<Appender<ILoggingEvent>> iter, int depth) throws IllegalAccessException {
        block0: while (iter.hasNext()) {
            Appender<ILoggingEvent> a = iter.next();
            if (a instanceof AsyncAppenderBase) {
                Iterator aiter = ((AsyncAppenderBase)a).iteratorForAppenders();
                LogbackHelper.doSetDepth(aiter, depth);
                continue;
            }
            if (!(a instanceof OutputStreamAppender)) continue;
            OutputStreamAppender oa = (OutputStreamAppender)a;
            Encoder e = oa.getEncoder();
            Layout l = null;
            if (e instanceof PatternLayoutEncoder) {
                l = ((PatternLayoutEncoder)e).getLayout();
            } else if (e instanceof LayoutWrappingEncoder) {
                l = ((LayoutWrappingEncoder)e).getLayout();
            }
            if (l == null || !(l instanceof PatternLayoutBase)) continue;
            for (Converter c = (Converter)f.get(l); c != null; c = c.getNext()) {
                if (!(c instanceof ThrowableProxyConverter)) continue;
                f1.set(c, depth);
                continue block0;
            }
        }
    }

    private static LoggerInfo doGetLoggerInfo(Logger logger) {
        LoggerInfo info = new LoggerInfo(logger.getName(), logger.isAdditive());
        Level level = logger.getLevel();
        Level effectiveLevel = logger.getEffectiveLevel();
        if (level != null) {
            info.setLevel(level.toString());
        }
        if (effectiveLevel != null) {
            info.setEffectiveLevel(effectiveLevel.toString());
        }
        List<AppenderInfo> result = LogbackHelper.doGetLoggerAppenders(logger.iteratorForAppenders());
        info.setAppenders(result);
        return info;
    }

    private static List<AppenderInfo> doGetLoggerAppenders(Iterator<Appender<ILoggingEvent>> appenders) {
        ArrayList<AppenderInfo> result = new ArrayList<AppenderInfo>();
        while (appenders.hasNext()) {
            AppenderInfo info = new AppenderInfo();
            Appender<ILoggingEvent> appender = appenders.next();
            info.setName(appender.getName());
            info.setType(appender.getClass().getName());
            if (appender instanceof FileAppender) {
                info.setFile(((FileAppender)appender).getFile());
            } else if (appender instanceof AsyncAppender) {
                AsyncAppender aa = (AsyncAppender)appender;
                Iterator iter = aa.iteratorForAppenders();
                List<AppenderInfo> asyncs = LogbackHelper.doGetLoggerAppenders(iter);
                ArrayList<String> nestedNames = new ArrayList<String>();
                for (AppenderInfo a : asyncs) {
                    nestedNames.add(a.getName());
                    result.add(a);
                }
                info.withDetail("nestedNames", nestedNames);
            } else if (appender instanceof ConsoleAppender) {
                info.withDetail("target", (Object)((ConsoleAppender)appender).getTarget());
            }
            result.add(info);
        }
        return result;
    }

    static {
        try {
            Class<?> loggerClass = Class.forName("ch.qos.logback.classic.Logger");
            if (loggerClass.getClassLoader().equals(LogbackHelper.class.getClassLoader())) {
                ILoggerFactory lc = LoggerFactory.getILoggerFactory();
                if (!(lc instanceof LoggerContext)) {
                    LogLog.warn((String)("expected logback binding with SLF4J, but another log system has taken the place: " + lcObject.getClass().getSimpleName()));
                } else {
                    lcObject = lc;
                    f = PatternLayoutBase.class.getDeclaredField("head");
                    f.setAccessible(true);
                    f1 = ThrowableProxyConverter.class.getDeclaredField("lengthOption");
                    f1.setAccessible(true);
                    Logback = true;
                }
            }
        }
        catch (Throwable t) {
            LogLog.error((String)("failed to init LogbackHelper, " + t.getMessage()));
        }
    }
}

