/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.spring;

import com.taobao.pandora.boot.common.utils.AnsiLog;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;

public class BootInfClassesDetector {
    private static final String FAT_JAR_REGEX = ".*\\/BOOT-INF\\/.*\\.jar\\!\\/BOOT-INF\\/classes\\/";

    public static void detect() {
        ClassLoader classLoader = BootInfClassesDetector.class.getClassLoader();
        try {
            Enumeration<URL> enumeration = classLoader.getResources("BOOT-INF/classes/");
            ArrayList<URL> fatjars = new ArrayList<URL>();
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                if (!url.toString().matches(FAT_JAR_REGEX)) continue;
                fatjars.add(url);
            }
            if (!fatjars.isEmpty()) {
                AnsiLog.error((String)"[BootInfClassesDetector] found fat jar in classpaths, the classes under BOOT-INF/classes/ can not be loaded.");
                for (URL url : fatjars) {
                    AnsiLog.error((String)url.toString());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

