/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.spring.diamond;

import com.taobao.diamond.client.Diamond;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;

public class DiamondProfiles {
    public static final String DEFAULT_DATAID = "alibaba-spring-boot:application.properties";
    public static final String DEFAULT_GROUPID = "DEFAULT_GROUP";
    public static final String DEFAULT_PROFILESKEY = "ali.env";

    public static String[] load() {
        return DiamondProfiles.load(DEFAULT_DATAID, DEFAULT_GROUPID, DEFAULT_PROFILESKEY, true);
    }

    public static String[] load(boolean failFast) {
        return DiamondProfiles.load(DEFAULT_DATAID, DEFAULT_GROUPID, DEFAULT_PROFILESKEY, failFast);
    }

    public static String[] load(String dataId, String groupId) {
        return DiamondProfiles.load(dataId, groupId, DEFAULT_PROFILESKEY, true);
    }

    public static String[] load(String dataId, String groupId, String profilesKey, boolean failFast) {
        try {
            String config = Diamond.getConfig((String)dataId, (String)groupId, (long)3000L);
            if (config == null || config.trim().isEmpty()) {
                if (failFast) {
                    throw new IllegalStateException("Load profiles config from diamond error! dataId: " + dataId + ", group: " + groupId);
                }
                return new String[0];
            }
            Properties properties = new Properties();
            properties.load(new StringReader(config));
            String profiles = properties.getProperty(profilesKey);
            return profiles.split("\\s*,\\s*");
        }
        catch (IOException e) {
            if (failFast) {
                throw new IllegalStateException(e);
            }
            return new String[0];
        }
    }
}

