/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.spring.logging;

import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.util.ClassUtils;

public class SLF4JBridgeHandlerRemoveListener
implements Ordered,
ApplicationListener<ApplicationStartingEvent> {
    private static final String BRIDGE_HANDLER = "org.slf4j.bridge.SLF4JBridgeHandler";
    private static final String SKIP_REMOVE_SLF4JBRIDGEHANDLER = "skipRemoveSLF4JBridgeHandler";

    public int getOrder() {
        return -2147483637;
    }

    public void onApplicationEvent(ApplicationStartingEvent event) {
        if (Boolean.getBoolean(SKIP_REMOVE_SLF4JBRIDGEHANDLER)) {
            System.out.println("Skip Remove SLF4JBridgeHandler.");
            return;
        }
        ClassLoader classLoader = event.getSpringApplication().getClassLoader();
        if (this.isBridgeHandlerAvailable(classLoader)) {
            this.removeSLF4JBridgeHandlerFromOtherClassLoader(classLoader);
        }
    }

    private final boolean isBridgeHandlerAvailable(ClassLoader classLoader) {
        return ClassUtils.isPresent((String)BRIDGE_HANDLER, (ClassLoader)classLoader);
    }

    private void removeSLF4JBridgeHandlerFromOtherClassLoader(ClassLoader classLoader) {
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        Handler[] handlers = rootLogger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Class<?> clazz = handlers[i].getClass();
            ClassLoader binderClassLoader = clazz.getClassLoader();
            if (binderClassLoader == null || binderClassLoader.equals(classLoader) || !clazz.getName().equals(BRIDGE_HANDLER)) continue;
            rootLogger.removeHandler(handlers[i]);
        }
    }
}

