/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.test.junit4;

import com.taobao.pandora.boot.common.utils.AnsiLog;
import com.taobao.pandora.boot.logconfig.LogConfigUtil;
import com.taobao.pandora.boot.test.junit4.DelegateTo;
import com.taobao.pandora.boot.test.junit4.Sar;
import com.taobao.pandora.boot.test.junit4.impl.Behavior;
import com.taobao.pandora.boot.test.junit4.impl.DefaultBehavior;
import com.taobao.pandora.boot.test.junit4.impl.ExistingCacheBehavior;
import com.taobao.pandora.boot.test.junit4.impl.NopBehavior;
import com.taobao.pandora.boot.test.junit4.impl.PandoraBootStarter;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.JUnit4;

public class PandoraBootRunner
extends Runner
implements Filterable {
    public static final String PANDORA_SKIP = "pandora.skip";
    private Runner runner;
    private Behavior behavior;

    public PandoraBootRunner(Class<?> testClass) throws Exception {
        if (System.getProperty(PANDORA_SKIP) == null || "false".equalsIgnoreCase(System.getProperty(PANDORA_SKIP))) {
            this.behavior = this.prepareClassLoader(testClass);
        } else {
            AnsiLog.warn((String)"[Pandora Boot] do not start pandora sar, skip.");
            this.behavior = new NopBehavior(testClass);
        }
        this.runner = this.prepareDelegateRunner(testClass, this.behavior);
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        filter.apply((Object)this.runner);
    }

    public Description getDescription() {
        return this.runner.getDescription();
    }

    public void run(RunNotifier notifier) {
        try {
            this.behavior.before();
            LogConfigUtil.initLoggingSystem((ClassLoader)Thread.currentThread().getContextClassLoader());
            this.runner.run(notifier);
        }
        finally {
            this.behavior.after();
        }
    }

    private Runner prepareDelegateRunner(Class<?> clazz, Behavior classLoader) throws Exception {
        Class<?> runnerClass = classLoader.loadClass(JUnit4.class.getName());
        DelegateTo delegateTo = clazz.getAnnotation(DelegateTo.class);
        if (delegateTo != null) {
            runnerClass = classLoader.loadClass(delegateTo.value().getName());
        }
        Class<?> testClassToInvoke = classLoader.loadClass(clazz.getName());
        Constructor<?> constructor = runnerClass.getConstructor(Class.class);
        constructor.setAccessible(true);
        return (Runner)constructor.newInstance(testClassToInvoke);
    }

    private Behavior prepareClassLoader(Class<?> clazz) throws Exception {
        Map<String, Class<?>> cache = PandoraBootRunner.findClassCache();
        boolean share = true;
        Sar sarInfo = clazz.getAnnotation(Sar.class);
        if (sarInfo != null) {
            share = sarInfo.share();
        }
        return cache == null ? new DefaultBehavior(clazz) : (share ? new ExistingCacheBehavior(clazz) : new DefaultBehavior(clazz));
    }

    private static Map<String, Class<?>> findClassCache() throws NoSuchFieldException, IllegalAccessException {
        return PandoraBootStarter.getExportedClassMap();
    }
}

