/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.alibaba.fastjson.JSONObject;
import com.taosdata.jdbc.ws.InFlightRequest;
import com.taosdata.jdbc.ws.ResponseFuture;
import com.taosdata.jdbc.ws.entity.Action;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.entity.Response;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class WSClient
extends WebSocketClient
implements AutoCloseable {
    private final String user;
    private final String password;
    private final String database;
    private final CountDownLatch latch;
    private final InFlightRequest inFlightRequest;
    ThreadPoolExecutor executor;
    private boolean auth;

    public boolean isAuth() {
        return this.auth;
    }

    public WSClient(URI serverUri, String user, String password, String database, InFlightRequest inFlightRequest, Map<String, String> httpHeaders, CountDownLatch latch, int maxRequest) {
        super(serverUri, httpHeaders);
        this.user = user;
        this.password = password;
        this.database = database;
        this.inFlightRequest = inFlightRequest;
        this.latch = latch;
        this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(maxRequest), r -> {
            Thread t = new Thread(r);
            t.setName("parse-message-" + t.getId());
            return t;
        }, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void onOpen(ServerHandshake serverHandshake) {
        Request request = Request.generateConnect(this.user, this.password, this.database);
        this.send(request.toString());
    }

    public void onMessage(String message) {
        if (!"".equals(message)) {
            this.executor.submit(() -> {
                JSONObject jsonObject = JSONObject.parseObject((String)message);
                if (Action.CONN.getAction().equals(jsonObject.getString("action"))) {
                    this.latch.countDown();
                    if (Code.SUCCESS.getCode() != jsonObject.getInteger("code").intValue()) {
                        this.auth = false;
                        this.close();
                    }
                } else {
                    Response response = this.parseMessage(jsonObject);
                    ResponseFuture remove = this.inFlightRequest.remove(response.id());
                    if (null != remove) {
                        remove.getFuture().complete(response);
                    }
                }
            });
        }
    }

    private Response parseMessage(JSONObject message) {
        Action action = Action.of(message.getString("action"));
        return (Response)message.toJavaObject(action.getResponseClazz());
    }

    public void onMessage(ByteBuffer bytes) {
        super.onMessage(bytes);
    }

    public void onClose(int code, String reason, boolean remote) {
        if (remote) {
            throw new RuntimeException("The remote server closed the connection: " + reason);
        }
        throw new RuntimeException("close connection: " + reason);
    }

    public void onError(Exception e) {
        this.close();
    }

    @Override
    public void close() {
        super.close();
        this.executor.shutdown();
        this.inFlightRequest.close();
    }
}

