/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.iot.explorer.device.android.data_template;

import android.content.Context;
import com.tencent.iot.explorer.device.android.data_template.TXDataTemplate;
import com.tencent.iot.explorer.device.android.mqtt.TXMqttConnection;
import com.tencent.iot.explorer.device.java.data_template.TXDataTemplateConstants;
import com.tencent.iot.explorer.device.java.data_template.TXDataTemplateDownStreamCallBack;
import com.tencent.iot.hub.device.java.core.common.Status;
import com.tencent.iot.hub.device.java.core.mqtt.TXMqttActionCallBack;
import com.tencent.iot.hub.device.java.core.mqtt.TXMqttConstants;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONArray;
import org.json.JSONObject;

public class TXDataTemplateClient
extends TXMqttConnection {
    private TXDataTemplate mDataTemplate;
    public String mPropertyDownStreamTopic;

    public TXDataTemplateClient(Context context, String serverURI, String productID, String deviceName, String secretKey, DisconnectedBufferOptions bufferOpts, MqttClientPersistence clientPersistence, TXMqttActionCallBack callBack, String jsonFileName, TXDataTemplateDownStreamCallBack downStreamCallBack) {
        super(context, serverURI, productID, deviceName, secretKey, bufferOpts, clientPersistence, callBack);
        this.mDataTemplate = new TXDataTemplate(context, this, productID, deviceName, jsonFileName, downStreamCallBack);
        this.mPropertyDownStreamTopic = this.mDataTemplate.mPropertyDownStreamTopic;
    }

    public boolean isConnected() {
        return this.getConnectStatus().equals((Object)TXMqttConstants.ConnectStatus.kConnected);
    }

    public Status subscribeTemplateTopic(TXDataTemplateConstants.TemplateSubTopic topicId, int qos) {
        return this.mDataTemplate.subscribeTemplateTopic(topicId, qos);
    }

    public Status unSubscribeTemplateTopic(TXDataTemplateConstants.TemplateSubTopic topicId) {
        return this.mDataTemplate.unSubscribeTemplateTopic(topicId);
    }

    public Status propertyReport(JSONObject property, JSONObject metadata) {
        return this.mDataTemplate.propertyReport(property, metadata);
    }

    public Status propertyGetStatus(String type, boolean showmeta) {
        return this.mDataTemplate.propertyGetStatus(type, showmeta);
    }

    public Status propertyReportInfo(JSONObject params) {
        return this.mDataTemplate.propertyReportInfo(params);
    }

    public Status propertyClearControl() {
        return this.mDataTemplate.propertyClearControl();
    }

    public Status eventSinglePost(String eventId, String type, JSONObject params) {
        return this.mDataTemplate.eventSinglePost(eventId, type, params);
    }

    public Status eventsPost(JSONArray events) {
        return this.mDataTemplate.eventsPost(events);
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        super.messageArrived(topic, message);
        this.mDataTemplate.onMessageArrived(topic, message);
    }
}

