/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.iot.explorer.device.android.data_template;

import android.content.Context;
import android.content.res.AssetManager;
import com.tencent.iot.explorer.device.android.utils.CustomLog;
import com.tencent.iot.explorer.device.android.utils.TXLog;
import com.tencent.iot.explorer.device.java.data_template.DataTemplateJson;
import com.tencent.iot.explorer.device.java.utils.ILog;
import com.tencent.iot.hub.device.java.core.common.Status;
import java.io.IOException;
import java.io.InputStream;
import org.json.JSONException;
import org.json.JSONObject;

class TXDataTemplateJson
extends DataTemplateJson {
    private static final String TAG = "TX_TEMPLATE_JSON_1.1.0";
    private static final CustomLog CUSTOM_LOG = new CustomLog("TX_TEMPLATE_JSON_1.1.0");

    TXDataTemplateJson(Context context, String jsonFileName) {
        super((ILog)CUSTOM_LOG);
        if (Status.OK != this.registerDataTemplateJson(context, jsonFileName)) {
            TXLog.e(TAG, "TXDataTemplateJson: construct json failed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status registerDataTemplateJson(Context context, String jsonFileName) {
        AssetManager assetManager = context.getAssets();
        if (assetManager == null) {
            return null;
        }
        InputStream jsonInputStream = null;
        try {
            jsonInputStream = assetManager.open(jsonFileName);
            String jsonStr = this.readInputStream(jsonInputStream);
            JSONObject json = new JSONObject(jsonStr);
            this.mPropertyJson = json.getJSONArray("properties");
            this.mEventJson = json.getJSONArray("events");
            this.mActionJson = json.getJSONArray("actions");
            TXLog.d(TAG, "registerDataTemplateJson: propertyJson" + this.mPropertyJson);
            TXLog.d(TAG, "registerDataTemplateJson: eventJson" + this.mEventJson);
            TXLog.d(TAG, "registerDataTemplateJson: actionJson" + this.mActionJson);
        }
        catch (IOException e) {
            TXLog.e(TAG, "Cannot open Json Files.", e);
            Status status = Status.ERROR;
            return status;
        }
        catch (JSONException t) {
            TXLog.e(TAG, "Json file format is invalid!.", t);
            Status status = Status.ERROR;
            return status;
        }
        finally {
            if (jsonInputStream != null) {
                try {
                    jsonInputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return Status.OK;
    }
}

