/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.iot.explorer.device.android.mqtt;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import com.tencent.iot.explorer.device.android.mqtt.TXAlarmPingSender;
import com.tencent.iot.explorer.device.android.utils.TXLog;
import com.tencent.iot.hub.device.java.core.common.Status;
import com.tencent.iot.hub.device.java.core.mqtt.TXMqttActionCallBack;
import com.tencent.iot.hub.device.java.core.mqtt.TXMqttConstants;
import com.tencent.iot.hub.device.java.core.util.HmacSha256;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttPingSender;

public class TXMqttConnection
extends com.tencent.iot.hub.device.java.core.mqtt.TXMqttConnection
implements MqttCallbackExtended {
    public static final String TAG = "TXMQTT_1.1.0";
    private static final String HMAC_SHA_256 = "HmacSHA256";
    private final String mWechatScanQRCodeContentUrl = "https://iot.cloud.tencent.com/iotexplorer/device";
    protected Context mContext;
    protected TXAlarmPingSender mPingSender = null;

    public TXMqttConnection(Context context, String productID, String deviceName, String secretKey, TXMqttActionCallBack callBack) {
        this(context, productID, deviceName, secretKey, null, callBack);
    }

    public TXMqttConnection(Context context, String productID, String deviceName, String secretKey, DisconnectedBufferOptions bufferOpts, TXMqttActionCallBack callBack) {
        this(context, productID, deviceName, secretKey, bufferOpts, null, callBack);
    }

    public TXMqttConnection(Context context, String productID, String deviceName, String secretKey, DisconnectedBufferOptions bufferOpts, MqttClientPersistence clientPersistence, TXMqttActionCallBack callBack) {
        this(context, null, productID, deviceName, secretKey, bufferOpts, clientPersistence, callBack);
    }

    public TXMqttConnection(Context context, String serverURI, String productID, String deviceName, String secretKey, DisconnectedBufferOptions bufferOpts, MqttClientPersistence clientPersistence, TXMqttActionCallBack callBack) {
        super(serverURI, productID, deviceName, secretKey, bufferOpts, clientPersistence, callBack);
        this.mContext = context;
    }

    public String generateDeviceQRCodeContent() {
        int randNum = (int)(Math.random() * 999999.0);
        long timestamp = System.currentTimeMillis() / 1000L;
        String text2Sgin = this.mProductId + this.mDeviceName + ";" + randNum + ";" + timestamp;
        String signature = this.sign(text2Sgin, this.mSecretKey);
        String content = this.mProductId + ";" + this.mDeviceName + ";" + randNum + ";" + timestamp + ";hmacsha256;" + signature;
        return content;
    }

    public String generateDeviceWechatScanQRCodeContent() {
        String deviceSign = "";
        try {
            deviceSign = URLEncoder.encode(this.generateDeviceQRCodeContent(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            TXLog.e(TAG, "toURLEncoded error:" + deviceSign + e.toString());
            return "";
        }
        String content = "https://iot.cloud.tencent.com/iotexplorer/device?page=adddevice&productId=" + this.mProductId + "&device_sign=" + deviceSign;
        return content;
    }

    private String sign(String src, String psk) {
        Mac mac;
        try {
            mac = Mac.getInstance(HMAC_SHA_256);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        SecretKeySpec signKey = new SecretKeySpec(Base64.decode((String)psk, (int)0), HMAC_SHA_256);
        try {
            mac.init(signKey);
            byte[] rawHmac = mac.doFinal(src.getBytes());
            String hmacSign = Base64.encodeToString((byte[])rawHmac, (int)2);
            return hmacSign;
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized Status connect(MqttConnectOptions options, Object userContext) {
        if (this.mConnectStatus.equals((Object)TXMqttConstants.ConnectStatus.kConnecting)) {
            TXLog.i(TAG, "The client is connecting. Connect return directly.");
            return Status.MQTT_CONNECT_IN_PROGRESS;
        }
        if (this.mConnectStatus.equals((Object)TXMqttConstants.ConnectStatus.kConnected)) {
            TXLog.i(TAG, "The client is already connected. Connect return directly.");
            return Status.OK;
        }
        this.mConnOptions = options;
        if (this.mConnOptions == null) {
            TXLog.e(TAG, "Connect options == null, will not connect.");
            return Status.PARAMETER_INVALID;
        }
        Long timestamp = options.isAutomaticReconnect() ? Long.valueOf(Integer.MAX_VALUE) : Long.valueOf(System.currentTimeMillis() / 1000L + 600L);
        String userNameStr = this.mUserName + ";" + this.getConnectId() + ";" + timestamp;
        this.mConnOptions.setUserName(userNameStr);
        if (this.mSecretKey != null && this.mSecretKey.length() != 0) {
            try {
                String passWordStr = HmacSha256.getSignature((byte[])userNameStr.getBytes(), (byte[])Base64.decode((String)this.mSecretKey, (int)0)) + ";hmacsha256";
                this.mConnOptions.setPassword(passWordStr.toCharArray());
            }
            catch (IllegalArgumentException e) {
                Log.d((String)TAG, (String)"Failed to set password");
            }
        }
        this.mConnOptions.setMqttVersion(4);
        IMqttActionListener mActionListener = new IMqttActionListener(){

            public void onSuccess(IMqttToken token) {
                TXLog.i(TXMqttConnection.TAG, "onSuccess!");
                TXMqttConnection.this.setConnectingState(TXMqttConstants.ConnectStatus.kConnected);
                TXMqttConnection.this.mActionCallBack.onConnectCompleted(Status.OK, false, token.getUserContext(), "connected to " + TXMqttConnection.this.mServerURI);
            }

            public void onFailure(IMqttToken token, Throwable exception) {
                TXLog.e(TXMqttConnection.TAG, exception, "onFailure!", new Object[0]);
                TXMqttConnection.this.setConnectingState(TXMqttConstants.ConnectStatus.kConnectFailed);
                TXMqttConnection.this.mActionCallBack.onConnectCompleted(Status.ERROR, false, token.getUserContext(), exception.toString());
            }
        };
        if (this.mMqttClient == null) {
            try {
                this.mPingSender = new TXAlarmPingSender(this.mContext);
                this.mMqttClient = new MqttAsyncClient(this.mServerURI, this.mClientId, this.mMqttPersist, (MqttPingSender)this.mPingSender);
                this.mMqttClient.setCallback((MqttCallback)this);
                this.mMqttClient.setBufferOpts(this.bufferOpts);
                this.mMqttClient.setManualAcks(false);
            }
            catch (Exception e) {
                TXLog.e(TAG, "new MqttClient failed", e);
                this.setConnectingState(TXMqttConstants.ConnectStatus.kConnectFailed);
                return Status.ERROR;
            }
        }
        try {
            TXLog.i(TAG, "Start connecting to %s", this.mServerURI);
            this.setConnectingState(TXMqttConstants.ConnectStatus.kConnecting);
            this.mMqttClient.connect(this.mConnOptions, userContext, mActionListener);
        }
        catch (Exception e) {
            TXLog.e(TAG, "MqttClient connect failed", e);
            this.setConnectingState(TXMqttConstants.ConnectStatus.kConnectFailed);
            return Status.ERROR;
        }
        return Status.OK;
    }
}

