/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.iot.explorer.device.android.utils;

import android.content.Context;
import android.content.res.AssetManager;
import com.tencent.iot.explorer.device.android.utils.TXLog;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.net.ssl.SSLSocketFactory;

public class AsymcSslUtils {
    public static final String TAG = "iot.AsymcSslUtils";
    private static String PASSWORD = String.valueOf(new Random(System.currentTimeMillis()).nextInt());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLSocketFactory getSocketFactoryByAssetsFile(Context context, String clientCrtFileName, String clientPriKeyFileName) {
        SSLSocketFactory factory = null;
        AssetManager assetManager = context.getAssets();
        if (assetManager == null) {
            return null;
        }
        InputStream clientInputStream = null;
        InputStream keyInputStream = null;
        try {
            clientInputStream = assetManager.open(clientCrtFileName);
            keyInputStream = assetManager.open(clientPriKeyFileName);
            factory = AsymcSslUtils.getSocketFactoryByStream(clientInputStream, keyInputStream);
        }
        catch (IOException e) {
            TXLog.e(TAG, "getSocketFactory failed, cannot open CRT Files.", e);
        }
        finally {
            if (clientInputStream != null) {
                try {
                    clientInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (keyInputStream != null) {
                try {
                    keyInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return factory;
    }

    public static SSLSocketFactory getSocketFactoryByFile(String clientCrtFileName, String clientPriKeyFileName) {
        return com.tencent.iot.hub.device.java.core.util.AsymcSslUtils.getSocketFactoryByFile((String)clientCrtFileName, (String)clientPriKeyFileName);
    }

    public static SSLSocketFactory getSocketFactoryByStream(InputStream clientInput, InputStream keyInput) {
        return com.tencent.iot.hub.device.java.core.util.AsymcSslUtils.getSocketFactoryByStream((InputStream)clientInput, (InputStream)keyInput);
    }

    public static SSLSocketFactory getSocketFactoryByStream(InputStream clientInput, InputStream keyInput, String customCA) {
        return com.tencent.iot.hub.device.java.core.util.AsymcSslUtils.getSocketFactoryByStream((InputStream)clientInput, (InputStream)keyInput, (String)customCA);
    }

    public static SSLSocketFactory getSocketFactory() {
        return com.tencent.iot.hub.device.java.core.util.AsymcSslUtils.getSocketFactory();
    }

    public static SSLSocketFactory getSocketFactory(String customCA) {
        return com.tencent.iot.hub.device.java.core.util.AsymcSslUtils.getSocketFactory((String)customCA);
    }
}

