/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.iot.explorer.device.android.utils;

import android.content.Context;
import android.os.Build;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import com.tencent.iot.explorer.device.android.utils.TXLogImpl;

public class TXLog {
    private static final String TAG = "mars.xlog.log";
    public static final int LEVEL_VERBOSE = 0;
    public static final int LEVEL_DEBUG = 1;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_WARNING = 3;
    public static final int LEVEL_ERROR = 4;
    public static final int LEVEL_FATAL = 5;
    public static final int LEVEL_NONE = 6;
    public static Context toastSupportContext = null;
    private static LogImp logImp = new TXLogImpl();
    private static final String SYS_INFO;

    public static void setLogImp(LogImp imp) {
        logImp = imp;
    }

    public static LogImp getImpl() {
        return logImp;
    }

    public static int getLogLevel() {
        if (logImp != null) {
            return logImp.getLogLevel();
        }
        return 6;
    }

    public static void setLevel(int level) {
        logImp.setLogLevel(level);
    }

    public static void f(String tag, String msg) {
        TXLog.f(tag, msg, null);
    }

    public static void e(String tag, String msg) {
        TXLog.e(tag, msg, (Object[])null);
    }

    public static void e(String tag, String msg, Throwable tr) {
        TXLog.e(tag, tr, msg, (Object[])null);
    }

    public static void w(String tag, String msg) {
        TXLog.w(tag, msg, null);
    }

    public static void i(String tag, String msg) {
        TXLog.i(tag, msg, null);
    }

    public static void d(String tag, String msg) {
        TXLog.d(tag, msg, null);
    }

    public static void v(String tag, String msg) {
        TXLog.v(tag, msg, null);
    }

    public static void f(String tag, String format, Object ... obj) {
        if (logImp != null) {
            String log = obj == null ? format : String.format(format, obj);
            logImp.logF(tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void e(String tag, String format, Object ... obj) {
        if (logImp != null) {
            String log;
            String string = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            Log.e((String)tag, (String)log);
            logImp.logE(tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void w(String tag, String format, Object ... obj) {
        if (logImp != null) {
            String log;
            String string = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            Log.w((String)tag, (String)log);
            logImp.logW(tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void i(String tag, String format, Object ... obj) {
        if (logImp != null) {
            String log;
            String string = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            Log.i((String)tag, (String)log);
            logImp.logI(tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void d(String tag, String format, Object ... obj) {
        if (logImp != null) {
            String log;
            String string = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            Log.d((String)tag, (String)log);
            logImp.logD(tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void v(String tag, String format, Object ... obj) {
        if (logImp != null) {
            String log;
            String string = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            Log.v((String)tag, (String)log);
            logImp.logV(tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void e(String tag, Throwable tr, String format, Object ... obj) {
        if (logImp != null) {
            String log;
            String string = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            Log.e((String)tag, (String)log, (Throwable)tr);
            log = log + "\n" + Log.getStackTraceString((Throwable)tr);
            logImp.logE(tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static String getSysInfo() {
        return SYS_INFO;
    }

    static {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("VERSION.RELEASE:[" + Build.VERSION.RELEASE);
            sb.append("] VERSION.CODENAME:[" + Build.VERSION.CODENAME);
            sb.append("] VERSION.INCREMENTAL:[" + Build.VERSION.INCREMENTAL);
            sb.append("] BOARD:[" + Build.BOARD);
            sb.append("] DEVICE:[" + Build.DEVICE);
            sb.append("] DISPLAY:[" + Build.DISPLAY);
            sb.append("] FINGERPRINT:[" + Build.FINGERPRINT);
            sb.append("] HOST:[" + Build.HOST);
            sb.append("] MANUFACTURER:[" + Build.MANUFACTURER);
            sb.append("] MODEL:[" + Build.MODEL);
            sb.append("] PRODUCT:[" + Build.PRODUCT);
            sb.append("] TAGS:[" + Build.TAGS);
            sb.append("] TYPE:[" + Build.TYPE);
            sb.append("] USER:[" + Build.USER + "]");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        SYS_INFO = sb.toString();
    }

    public static interface LogImp {
        public void logV(String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

        public void logI(String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

        public void logD(String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

        public void logW(String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

        public void logE(String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

        public void logF(String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

        public int getLogLevel();

        public void setLogLevel(int var1);
    }
}

