/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.iot.explorer.device.android.utils;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.tencent.iot.explorer.device.android.utils.TXLog;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class TXLogImpl
implements TXLog.LogImp {
    private static volatile Context sContext;
    private static String packageName;
    static LinkedBlockingDeque<String> logDeque;
    private static final int[] INTERVAL_RETRY_INIT;
    private static AtomicInteger retryInitTimes;
    public static final SimpleDateFormat timeFormatter;
    private static String logTime;
    private static String logPath;
    private static int logDuration;
    static String nowUsedFile;
    static final ReentrantLock lock;
    protected static Object formatterLock;
    private static long nextDayTime;
    private static long nextSecondMinuteTime;
    static long lastWriterErrorTime;
    private static FileWriter writer;
    private static Handler retryInitHandler;
    private int logLevel = 2;
    static Thread takeThread;
    public static Runnable initRunnable;

    public static void init(Context context) {
        TXLogImpl.init(context, logDuration);
    }

    public static void init(Context context, int duration) {
        sContext = context;
        logDuration = duration;
        initRunnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void writeLogToFile(String log) {
        block16: {
            try {
                if (!"mounted".equals(Environment.getExternalStorageState())) {
                    System.out.println("writeLogToFile not ready");
                    return;
                }
                if (null == writer) {
                    System.out.println("can not write log.");
                    long now = System.currentTimeMillis();
                    if (lastWriterErrorTime == 0L) {
                        lastWriterErrorTime = now;
                        break block16;
                    }
                    if (now - lastWriterErrorTime <= 60000L) break block16;
                    try {
                        TXLogImpl.initLogFile(System.currentTimeMillis());
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    lastWriterErrorTime = now;
                    break block16;
                }
                long now = System.currentTimeMillis();
                if (now > nextDayTime) {
                    TXLogImpl.initLogFile(now);
                }
                if (lock.tryLock()) {
                    try {
                        writer.write(log);
                        writer.flush();
                        break block16;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                if (!TXLogImpl.insertLogToCacheHead(log)) {
                    System.out.println("insertLogToCacheHead failed!");
                }
            }
            catch (Throwable e) {
                if (e instanceof IOException && e.getMessage().contains("ENOSPC")) {
                    e.printStackTrace();
                }
                try {
                    TXLogImpl.initLogFile(System.currentTimeMillis());
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private static String getDateStr(long nowCurrentMillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(nowCurrentMillis);
        SimpleDateFormat logFileFormatter = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat timeFormatter = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
        logTime = timeFormatter.format(nowCurrentMillis);
        String thisLogName = logFileFormatter.format(calendar.getTime());
        TXLogImpl.setNextSecond(calendar);
        TXLogImpl.setNextHour(calendar);
        return thisLogName;
    }

    private static void setNextHour(Calendar setSecondedCalendar) {
        setSecondedCalendar.add(5, 1);
        nextDayTime = setSecondedCalendar.getTimeInMillis();
    }

    private static void setNextSecond(Calendar calendar) {
        calendar.set(14, 0);
        nextSecondMinuteTime = calendar.getTimeInMillis() + 1000L;
    }

    public static String getLogFileName(String dataStr) {
        return "iot_" + dataStr + ".log";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void checkNextMinuteTime(long currentTimeMillis) {
        if (currentTimeMillis > nextSecondMinuteTime) {
            Object object = formatterLock;
            synchronized (object) {
                logTime = timeFormatter.format(currentTimeMillis);
                nextSecondMinuteTime += 1000L;
            }
        }
    }

    public static String getLogPath() {
        return logPath;
    }

    static synchronized void initLogFile(long nowCurrentTimeMillis) throws IOException {
        logPath = Environment.getExternalStorageDirectory().getPath() + "/tencent/" + packageName.replace(".", "/") + "/";
        File tmpeFile = new File(logPath);
        if (!tmpeFile.exists()) {
            tmpeFile.mkdirs();
        }
        nowUsedFile = logPath + TXLogImpl.getLogFileName(TXLogImpl.getDateStr(nowCurrentTimeMillis));
        try {
            tmpeFile = new File(nowUsedFile);
            if (!tmpeFile.exists()) {
                boolean b = tmpeFile.createNewFile();
                if (null != writer) {
                    writer.write(logTime + "||D|" + Build.MODEL + " " + Build.VERSION.RELEASE + " create newLogFile " + tmpeFile.getName() + " " + b + "\n");
                    writer.flush();
                }
            } else if (null != writer) {
                writer.write(logTime + "||E|" + Build.MODEL + " " + Build.VERSION.RELEASE + "|newLogFile " + tmpeFile.getName() + " is existed.\n");
                writer.flush();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        writer = new FileWriter(tmpeFile, true);
    }

    static void deleteExpiredLogs(long today) {
        logPath = Environment.getExternalStorageDirectory().getPath() + "/tencent/" + packageName.replace(".", "/") + "/";
        long day = 86400000L;
        for (long i = today - (long)logDuration * day; i > today - (long)(logDuration + 30) * day; i -= day) {
            String date = TXLogImpl.getDateStr(i);
            nowUsedFile = logPath + TXLogImpl.getLogFileName(date);
            try {
                File tmpeFile = new File(nowUsedFile);
                if (!tmpeFile.exists()) continue;
                tmpeFile.delete();
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeLog(String level, String tag, String msg, Throwable tr) {
        long now = System.currentTimeMillis();
        if (now >= nextSecondMinuteTime) {
            TXLogImpl.checkNextMinuteTime(now);
        }
        long threadId = Thread.currentThread().getId();
        String message = logTime + "|" + level + "|" + String.valueOf(threadId) + "|" + tag + "|" + msg + "\n";
        if (null != tr) {
            message = msg + "\n" + Log.getStackTraceString((Throwable)tr) + "\n";
        }
        TXLogImpl.addLogToCache(message);
    }

    private static boolean addLogToCache(String log) {
        try {
            logDeque.add(log);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean insertLogToCacheHead(String log) {
        try {
            logDeque.addFirst(log);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void logV(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
        long now = System.currentTimeMillis();
        if (now >= nextSecondMinuteTime) {
            TXLogImpl.checkNextMinuteTime(now);
        }
        String message = logTime + "|" + (Object)((Object)LogLevel.VERBOSE) + "|" + pid + "|" + tid + "|" + tag + "|" + log + "\n";
        TXLogImpl.addLogToCache(message);
    }

    @Override
    public void logI(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
        long now = System.currentTimeMillis();
        if (now >= nextSecondMinuteTime) {
            TXLogImpl.checkNextMinuteTime(now);
        }
        String message = logTime + "|" + (Object)((Object)LogLevel.INFO) + "|" + pid + "|" + tid + "|" + tag + "|" + log + "\n";
        TXLogImpl.addLogToCache(message);
    }

    @Override
    public void logD(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
        long now = System.currentTimeMillis();
        if (now >= nextSecondMinuteTime) {
            TXLogImpl.checkNextMinuteTime(now);
        }
        String message = logTime + "|" + (Object)((Object)LogLevel.DEBUG) + "|" + pid + "|" + tid + "|" + tag + "|" + log + "\n";
        TXLogImpl.addLogToCache(message);
    }

    @Override
    public void logW(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
        long now = System.currentTimeMillis();
        if (now >= nextSecondMinuteTime) {
            TXLogImpl.checkNextMinuteTime(now);
        }
        String message = logTime + "|" + (Object)((Object)LogLevel.WARN) + "|" + pid + "|" + tid + "|" + tag + "|" + log + "\n";
        TXLogImpl.addLogToCache(message);
    }

    @Override
    public void logE(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
        long now = System.currentTimeMillis();
        if (now >= nextSecondMinuteTime) {
            TXLogImpl.checkNextMinuteTime(now);
        }
        String message = logTime + "|" + (Object)((Object)LogLevel.ERROR) + "|" + pid + "|" + tid + "|" + tag + "|" + log + "\n";
        TXLogImpl.addLogToCache(message);
    }

    @Override
    public void logF(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
        long now = System.currentTimeMillis();
        if (now >= nextSecondMinuteTime) {
            TXLogImpl.checkNextMinuteTime(now);
        }
        String message = logTime + "|" + (Object)((Object)LogLevel.OFF) + "|" + pid + "|" + tid + "|" + tag + "|" + log + "\n";
        TXLogImpl.addLogToCache(message);
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(int level) {
        this.logLevel = level;
    }

    static {
        packageName = "";
        logDeque = new LinkedBlockingDeque(15000);
        INTERVAL_RETRY_INIT = new int[]{1, 2, 4, 8, 16, 29};
        retryInitTimes = new AtomicInteger(0);
        timeFormatter = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
        logTime = "";
        logPath = "";
        logDuration = 7;
        nowUsedFile = "";
        lock = new ReentrantLock();
        formatterLock = new Object();
        lastWriterErrorTime = 0L;
        retryInitHandler = new Handler(Looper.getMainLooper());
        takeThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        try {
                            String log = logDeque.take();
                            if (null != log) {
                                TXLogImpl.writeLogToFile(log);
                            }
                        }
                        catch (Exception e) {
                            System.out.println("write log file error: " + e.toString());
                        }
                        catch (AssertionError ignore) {
                            System.out.println("--------------");
                        }
                    }
                }
            }
        };
        initRunnable = new Runnable(){

            @Override
            public void run() {
                if (null == sContext) {
                    return;
                }
                new Thread("QLogInitThread"){

                    @Override
                    public void run() {
                        try {
                            try {
                                packageName = sContext.getPackageName();
                            }
                            catch (Exception e) {
                                packageName = "unknown";
                            }
                            TXLogImpl.deleteExpiredLogs(System.currentTimeMillis());
                            TXLogImpl.initLogFile(System.currentTimeMillis());
                            takeThread.setName("logWriteThread");
                            takeThread.start();
                            retryInitHandler.removeCallbacks(initRunnable);
                        }
                        catch (Exception e) {
                            int times = retryInitTimes.get();
                            System.out.println("QLogImpl init post retry " + times + " times, interval " + INTERVAL_RETRY_INIT[times]);
                            retryInitHandler.removeCallbacks(initRunnable);
                            retryInitHandler.postDelayed(initRunnable, (long)(INTERVAL_RETRY_INIT[times] * 60000));
                            if (++times >= INTERVAL_RETRY_INIT.length) {
                                times = 0;
                            }
                            retryInitTimes.set(times);
                        }
                    }
                }.start();
            }
        };
    }

    static enum LogLevel {
        OFF("OFF"),
        ERROR("ERROR"),
        WARN("WARN"),
        INFO("INFO"),
        DEBUG("DEBUG"),
        VERBOSE("VERBOSE");

        private String descr = "INFO";

        private LogLevel(String descr) {
            this.descr = descr;
        }
    }
}

