/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.iot.explorer.device.rtc.data_template;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.iot.explorer.device.android.mqtt.TXMqttConnection;
import com.tencent.iot.explorer.device.android.utils.TXLog;
import com.tencent.iot.explorer.device.common.stateflow.OnCall;
import com.tencent.iot.explorer.device.common.stateflow.TXCallDataTemplate;
import com.tencent.iot.explorer.device.common.stateflow.entity.CallExtraInfo;
import com.tencent.iot.explorer.device.common.stateflow.entity.RoomKey;
import com.tencent.iot.explorer.device.java.data_template.TXDataTemplateDownStreamCallBack;
import com.tencent.iot.explorer.device.rtc.data_template.model.TRTCUIManager;
import com.tencent.iot.hub.device.java.core.common.Status;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONObject;

public class TXTRTCDataTemplate
extends TXCallDataTemplate {
    private String TAG = TXTRTCDataTemplate.class.getSimpleName();

    public TXTRTCDataTemplate(Context context, TXMqttConnection connection, String productId, String deviceName, String jsonFileName, TXDataTemplateDownStreamCallBack downStreamCallBack, OnCall trtcCallBack) {
        super(context, connection, productId, deviceName, jsonFileName, downStreamCallBack, trtcCallBack);
    }

    @Override
    public void onActionMessageArrivedCallBack(MqttMessage message) {
        TXLog.d((String)this.TAG, (String)("action down stream message received " + message));
        try {
            String actionId;
            JSONObject jsonObj = new JSONObject(new String(message.getPayload()));
            String method = jsonObj.getString("method");
            if (method.equals("action") && jsonObj.has("actionId") && (actionId = jsonObj.getString("actionId")).equals("_sys_trtc_join_room")) {
                JSONObject params = jsonObj.getJSONObject("params");
                if (this.mTrtcCallBack != null) {
                    Integer SdkAppId = params.getInt("SdkAppId");
                    String UserId = params.getString("UserId");
                    String UserSig = params.getString("UserSig");
                    String StrRoomId = params.getString("StrRoomId");
                    RoomKey room = new RoomKey();
                    room.setAppId(SdkAppId);
                    room.setUserId(UserId);
                    room.setUserSig(UserSig);
                    room.setRoomId(StrRoomId);
                    room.setCallType(2);
                    if (TRTCUIManager.getInstance().callingUserId == "") {
                        this.mTrtcCallBack.trtcJoinRoomCallBack(room);
                    }
                }
            }
        }
        catch (Exception e) {
            TXLog.e((String)this.TAG, (String)("onActionMessageArrivedCallBack: invalid message: " + message));
        }
    }

    @Override
    public void onPropertyMessageArrivedCallBack(MqttMessage message) {
        TXLog.d((String)this.TAG, (String)("property down stream message received " + message));
        try {
            JSONObject data;
            JSONObject jsonObj = new JSONObject(new String(message.getPayload()));
            String method = jsonObj.getString("method");
            if (method.equals("control")) {
                JSONObject params = jsonObj.getJSONObject("params");
                if (this.mTrtcCallBack != null) {
                    Status status;
                    if (params.has("_sys_video_call_status")) {
                        CallExtraInfo tmp;
                        Integer callStatus = params.getInt("_sys_video_call_status");
                        String userid = "";
                        if (!this.isBusy() && callStatus == 1) {
                            this.setCallOther(false);
                        }
                        if ((tmp = this.getCallExtraInfo(params)) != null && !TextUtils.isEmpty((CharSequence)tmp.getCallerId())) {
                            userid = this.isCallOther() ? tmp.getCalledId() : tmp.getCallerId();
                        }
                        String userAgent = "";
                        if (params.has("_sys_user_agent")) {
                            userAgent = params.getString("_sys_user_agent");
                        }
                        if (this.isBusy() && !this.isContainCurrentCallingUserid(userid)) {
                            if (callStatus != 0) {
                                this.reportExtraInfoRejectUserId(userid);
                            }
                            return;
                        }
                        if (!this.isBusy() || callStatus != 1) {
                            this.mTrtcCallBack.onGetCallStatusCallBack(callStatus, userid, userAgent, 2, this.getCallExtraInfo(params));
                        }
                        if (callStatus == 0) {
                            this.setBusy(false);
                            this.setCurrentCallingUserid("");
                        } else {
                            this.setBusy(true);
                            this.setCurrentCallingUserid(userid);
                        }
                    } else if (params.has("_sys_audio_call_status")) {
                        CallExtraInfo tmp;
                        Integer callStatus = params.getInt("_sys_audio_call_status");
                        String userid = "";
                        if (!this.isBusy() && callStatus == 1) {
                            this.setCallOther(false);
                        }
                        if ((tmp = this.getCallExtraInfo(params)) != null && !TextUtils.isEmpty((CharSequence)tmp.getCallerId())) {
                            userid = this.isCallOther() ? tmp.getCalledId() : tmp.getCallerId();
                        }
                        String userAgent = "";
                        if (params.has("_sys_user_agent")) {
                            userAgent = params.getString("_sys_user_agent");
                        }
                        if (this.isBusy() && !this.isContainCurrentCallingUserid(userid)) {
                            if (callStatus != 0) {
                                this.reportExtraInfoRejectUserId(userid);
                            }
                            return;
                        }
                        if (!this.isBusy() || callStatus != 1) {
                            this.mTrtcCallBack.onGetCallStatusCallBack(callStatus, userid, userAgent, 1, tmp);
                        }
                        if (callStatus == 0) {
                            this.setBusy(false);
                            this.setCurrentCallingUserid("");
                        } else {
                            this.setBusy(true);
                            this.setCurrentCallingUserid(userid);
                        }
                    } else if (params.has("_sys_call_userlist") && Status.OK != (status = this.sysPropertyReport(params, null))) {
                        TXLog.e((String)this.TAG, (String)"property report failed!");
                    }
                }
            } else if (method.equals("get_status_reply") && (data = jsonObj.getJSONObject("data").getJSONObject("reported")).has("_sys_video_call_status") && data.has("_sys_audio_call_status")) {
                Integer videoCallStatus = data.getInt("_sys_video_call_status");
                Integer audioCallStatus = data.getInt("_sys_audio_call_status");
                if (!(this.isBusy() || videoCallStatus == 0 && audioCallStatus == 0)) {
                    this.reportResetCallStatusProperty();
                }
            }
        }
        catch (Exception e) {
            TXLog.e((String)this.TAG, (String)("onPropertyMessageArrivedCallBack: invalid message: " + message));
        }
    }

    private void onServiceMessageArrivedCallBack(MqttMessage message) {
        TXLog.d((String)this.TAG, (String)("service down stream message received : " + message));
        try {
            JSONObject jsonObj = new JSONObject(new String(message.getPayload()));
            String method = jsonObj.getString("method");
            if (method.equals("get_user_avatar_reply") && jsonObj.has("code")) {
                Integer code = jsonObj.getInt("code");
                String errorMsg = jsonObj.getString("status");
                if (code == 0 && jsonObj.has("response")) {
                    JSONObject avatarList = jsonObj.getJSONObject("response").getJSONObject("data");
                    this.mTrtcCallBack.trtcGetUserAvatarCallBack(code, errorMsg, avatarList);
                } else {
                    this.mTrtcCallBack.trtcGetUserAvatarCallBack(code, errorMsg, null);
                }
            }
        }
        catch (Exception e) {
            TXLog.e((String)this.TAG, (String)("onServiceMessageArrivedCallBack: invalid message:" + message));
        }
    }

    @Override
    public void onMessageArrived(String topic, MqttMessage message) throws Exception {
        super.onMessageArrived(topic, message);
        if (topic.equals(this.mPropertyDownStreamTopic)) {
            this.onPropertyMessageArrivedCallBack(message);
        } else if (topic.equals("$thing/down/action/" + this.mProductId + "/" + this.mDeviceName)) {
            this.onActionMessageArrivedCallBack(message);
        } else if (topic.equals("$thing/down/service/" + this.mProductId + "/" + this.mDeviceName)) {
            this.onServiceMessageArrivedCallBack(message);
        }
    }

    @Override
    public Status reportCallStatusProperty(Integer callStatus, Integer callType, String userId, String agent, JSONObject params) {
        this.setCallOther(TRTCUIManager.getInstance().callMobile);
        return super.reportCallStatusProperty(callStatus, callType, userId, agent, params);
    }
}

