/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.iot.explorer.device.common.stateflow;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.iot.explorer.device.android.data_template.TXDataTemplate;
import com.tencent.iot.explorer.device.android.mqtt.TXMqttConnection;
import com.tencent.iot.explorer.device.android.utils.TXLog;
import com.tencent.iot.explorer.device.common.stateflow.OnCall;
import com.tencent.iot.explorer.device.common.stateflow.entity.CallExtraInfo;
import com.tencent.iot.explorer.device.java.data_template.TXDataTemplateConstants;
import com.tencent.iot.explorer.device.java.data_template.TXDataTemplateDownStreamCallBack;
import com.tencent.iot.hub.device.java.core.common.Status;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TXCallDataTemplate
extends TXDataTemplate {
    private String TAG = TXCallDataTemplate.class.getSimpleName();
    private TXMqttConnection mConnection;
    public OnCall mTrtcCallBack = null;
    private static AtomicInteger requestID = new AtomicInteger(0);
    private boolean mIsBusy = false;
    private String mCurrentCallingUserid = "";
    private volatile boolean isCallOther = false;

    public String getCurrentCallingUserid() {
        return this.mCurrentCallingUserid;
    }

    public boolean isCallOther() {
        return this.isCallOther;
    }

    public void setCallOther(boolean callOther) {
        this.isCallOther = callOther;
    }

    public void setCurrentCallingUserid(String currentCallingUserid) {
        this.mCurrentCallingUserid = currentCallingUserid;
    }

    public TXCallDataTemplate(Context context, TXMqttConnection connection, String productId, String deviceName, String jsonFileName, TXDataTemplateDownStreamCallBack downStreamCallBack, OnCall trtcCallBack) {
        super(context, connection, productId, deviceName, jsonFileName, downStreamCallBack);
        this.mConnection = connection;
        this.mTrtcCallBack = trtcCallBack;
    }

    private void checkStatusIsNotIdleReportResetStatus() {
        this.propertyGetStatus("report", false);
    }

    public void onPropertyMessageArrivedCallBack(MqttMessage message) {
        TXLog.d((String)this.TAG, (String)("property down stream message received " + message));
    }

    public Status reportExtraInfoRejectUserId(String rejectUserId) {
        JSONObject property = new JSONObject();
        if (TextUtils.isEmpty((CharSequence)rejectUserId)) {
            TXLog.e((String)this.TAG, (String)"reportExtraInfoRejectUserId rejectUserId empty");
            return Status.PARAMETER_INVALID;
        }
        JSONObject extraInfo = new JSONObject();
        try {
            extraInfo.put("rejectUserId", (Object)rejectUserId);
            property.put("_sys_extra_info", (Object)extraInfo.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Status status = this.sysPropertyReport(property, null);
        if (Status.OK != status) {
            TXLog.e((String)this.TAG, (String)"property report failed!");
        }
        return status;
    }

    public void setBusy(boolean mIsBusy) {
        this.mIsBusy = mIsBusy;
    }

    public boolean isBusy() {
        return this.mIsBusy;
    }

    public void onActionMessageArrivedCallBack(MqttMessage message) {
        TXLog.d((String)this.TAG, (String)("action down stream message received " + message));
    }

    public Status reportCallStatusProperty(Integer callStatus, Integer callType, String userId, String agent, JSONObject params) {
        JSONObject property = new JSONObject();
        if (userId.equals("null") && params != null && params.length() != 0) {
            if (Status.OK != this.checkPropertyJson(property)) {
                TXLog.e((String)this.TAG, (String)"propertyReport: invalid property json!");
                return Status.PARAMETER_INVALID;
            }
            property = params;
        }
        try {
            String extraInfo;
            this.mIsBusy = callStatus != 0;
            String string = this.mCurrentCallingUserid = this.mIsBusy ? userId : "";
            if (callType == 2) {
                property.put("_sys_video_call_status", (Object)callStatus);
                if (!agent.equals("")) {
                    property.put("_sys_user_agent", (Object)agent);
                }
                if (!(extraInfo = "").equals("")) {
                    property.put("_sys_extra_info", (Object)extraInfo);
                }
            } else if (callType == 1) {
                property.put("_sys_audio_call_status", (Object)callStatus);
                if (!agent.equals("")) {
                    property.put("_sys_user_agent", (Object)agent);
                }
                if (!(extraInfo = "").equals("")) {
                    property.put("_sys_extra_info", (Object)extraInfo);
                }
            } else {
                return Status.ERR_JSON_CONSTRUCT;
            }
            if (this.isCallOther) {
                if (!userId.equals("")) {
                    property.put("_sys_called_id", (Object)userId);
                }
                property.put("_sys_caller_id", (Object)String.format("%s/%s", this.mProductId, this.mDeviceName));
            } else {
                if (!userId.equals("")) {
                    property.put("_sys_called_id", (Object)String.format("%s/%s", this.mProductId, this.mDeviceName));
                }
                property.put("_sys_caller_id", (Object)userId);
            }
        }
        catch (JSONException e) {
            TXLog.e((String)this.TAG, (String)"Construct property json failed!");
            return Status.ERROR;
        }
        Status status = this.sysPropertyReport(property, null);
        if (Status.OK != status) {
            TXLog.e((String)this.TAG, (String)"property report failed!");
        }
        if (callStatus == 0) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    TXCallDataTemplate.this.checkStatusIsNotIdleReportResetStatus();
                }
            };
            Timer timer = new Timer();
            timer.schedule(task, 1000L);
        }
        return status;
    }

    public Status reportCallStatusPropertyWithExtra(Integer callStatus, Integer callType, String userId, String agent, JSONObject params) {
        JSONObject property = new JSONObject();
        if (params != null && params.length() != 0) {
            if (Status.OK != this.checkPropertyJson(property)) {
                TXLog.e((String)this.TAG, (String)"propertyReport: invalid property json!");
                return Status.PARAMETER_INVALID;
            }
            property = params;
        }
        try {
            String extraInfo;
            this.mIsBusy = callStatus != 0;
            String string = this.mCurrentCallingUserid = this.mIsBusy ? userId : "";
            if (callType == 2) {
                property.put("_sys_video_call_status", (Object)callStatus);
                if (!agent.equals("")) {
                    property.put("_sys_user_agent", (Object)agent);
                }
                if (!(extraInfo = "").equals("")) {
                    property.put("_sys_extra_info", (Object)extraInfo);
                }
            } else if (callType == 1) {
                property.put("_sys_audio_call_status", (Object)callStatus);
                if (!agent.equals("")) {
                    property.put("_sys_user_agent", (Object)agent);
                }
                if (!(extraInfo = "").equals("")) {
                    property.put("_sys_extra_info", (Object)extraInfo);
                }
            } else {
                return Status.ERR_JSON_CONSTRUCT;
            }
            if (this.isCallOther) {
                if (!userId.equals("")) {
                    property.put("_sys_called_id", (Object)userId);
                }
                property.put("_sys_caller_id", (Object)String.format("%s/%s", this.mProductId, this.mDeviceName));
            } else {
                if (!userId.equals("")) {
                    property.put("_sys_called_id", (Object)String.format("%s/%s", this.mProductId, this.mDeviceName));
                }
                property.put("_sys_caller_id", (Object)userId);
            }
        }
        catch (JSONException e) {
            TXLog.e((String)this.TAG, (String)"Construct property json failed!");
            return Status.ERROR;
        }
        Status status = this.sysPropertyReport(property, null);
        if (Status.OK != status) {
            TXLog.e((String)this.TAG, (String)"property report failed!");
        }
        if (callStatus == 0) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    TXCallDataTemplate.this.checkStatusIsNotIdleReportResetStatus();
                }
            };
            Timer timer = new Timer();
            timer.schedule(task, 1000L);
        }
        return status;
    }

    public Status reportResetCallStatusProperty() {
        JSONObject property = new JSONObject();
        try {
            property.put("_sys_video_call_status", 0);
            property.put("_sys_audio_call_status", 0);
        }
        catch (JSONException e) {
            TXLog.e((String)this.TAG, (String)"Construct property json failed!");
            return Status.ERROR;
        }
        Status status = this.sysPropertyReport(property, null);
        if (Status.OK != status) {
            TXLog.e((String)this.TAG, (String)"property report failed!");
        }
        return status;
    }

    public Status sysPropertyReport(JSONObject property, JSONObject metadata) {
        JSONObject object = new JSONObject();
        String clientToken = this.mProductId + this.mDeviceName + String.valueOf(requestID.getAndIncrement());
        try {
            object.put("method", (Object)"report");
            object.put("clientToken", (Object)clientToken);
            object.put("timestamp", System.currentTimeMillis());
            object.put("params", (Object)property);
            if (null != metadata) {
                object.put("metadata", (Object)metadata);
            }
        }
        catch (Exception e) {
            TXLog.e((String)this.TAG, (String)"propertyReport: failed!");
            return Status.ERR_JSON_CONSTRUCT;
        }
        String objectString = object.toString();
        objectString = objectString.replace("\\/", "/");
        MqttMessage message = new MqttMessage();
        message.setQos(0);
        message.setPayload(objectString.getBytes());
        return this.publishTemplateMessage(clientToken, TXDataTemplateConstants.TemplatePubTopic.PROPERTY_UP_STREAM_TOPIC, message);
    }

    public void onMessageArrived(String topic, MqttMessage message) throws Exception {
        super.onMessageArrived(topic, message);
    }

    public CallExtraInfo getCallExtraInfo(JSONObject param) {
        String callerId = null;
        String calledId = null;
        try {
            if (param.has("_sys_caller_id")) {
                callerId = param.getString("_sys_caller_id");
            }
            if (param.has("_sys_called_id")) {
                calledId = param.getString("_sys_called_id");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        CallExtraInfo ret = new CallExtraInfo(callerId, calledId);
        return ret;
    }

    public Status getUserAvatar(JSONArray userIdsArray) {
        JSONObject object = new JSONObject();
        JSONObject params = new JSONObject();
        String clientToken = this.mProductId + this.mDeviceName + UUID.randomUUID().toString();
        try {
            object.put("method", (Object)"get_user_avatar");
            object.put("clientToken", (Object)clientToken);
            object.put("timestamp", System.currentTimeMillis());
            params.put("user_id_list", (Object)userIdsArray);
            object.put("params", (Object)params);
        }
        catch (Exception e) {
            TXLog.e((String)this.TAG, (String)"appBindToken: failed!");
            return Status.ERR_JSON_CONSTRUCT;
        }
        MqttMessage message = new MqttMessage();
        message.setQos(1);
        message.setPayload(object.toString().getBytes());
        return this.mConnection.publish("$thing/up/service/" + this.mProductId + "/" + this.mDeviceName, message, null);
    }
}

