/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.iot.explorer.device.common.stateflow;

import android.content.Context;
import com.tencent.iot.explorer.device.android.mqtt.TXMqttConnection;
import com.tencent.iot.explorer.device.common.stateflow.OnCall;
import com.tencent.iot.explorer.device.common.stateflow.TXCallDataTemplate;
import com.tencent.iot.explorer.device.java.data_template.TXDataTemplateConstants;
import com.tencent.iot.explorer.device.java.data_template.TXDataTemplateDownStreamCallBack;
import com.tencent.iot.hub.device.java.core.common.Status;
import com.tencent.iot.hub.device.java.core.mqtt.TXMqttActionCallBack;
import com.tencent.iot.hub.device.java.core.mqtt.TXMqttConstants;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONArray;
import org.json.JSONObject;

public class TXCallTemplateClient
extends TXMqttConnection {
    public TXCallDataTemplate mDataTemplate;
    public String mPropertyDownStreamTopic;

    public TXCallTemplateClient(Context context, String serverURI, String productID, String deviceName, String secretKey, DisconnectedBufferOptions bufferOpts, MqttClientPersistence clientPersistence, TXMqttActionCallBack callBack, String jsonFileName, TXDataTemplateDownStreamCallBack downStreamCallBack, OnCall trtcCallBack) {
        super(context, serverURI, productID, deviceName, secretKey, bufferOpts, clientPersistence, callBack);
    }

    public TXCallTemplateClient(Context context, String serverURI, String productID, String deviceName, String secretKey, DisconnectedBufferOptions bufferOpts, MqttClientPersistence clientPersistence, TXMqttActionCallBack callBack) {
        super(context, serverURI, productID, deviceName, secretKey, bufferOpts, clientPersistence, callBack);
    }

    public boolean isConnected() {
        return this.getConnectStatus().equals((Object)TXMqttConstants.ConnectStatus.kConnected);
    }

    public Status subscribeTemplateTopic(TXDataTemplateConstants.TemplateSubTopic topicId, int qos) {
        return this.mDataTemplate.subscribeTemplateTopic(topicId, qos);
    }

    public Status disConnect(Object userContext) {
        if (this.mDataTemplate != null) {
            this.mDataTemplate.destroy();
        }
        return this.disConnect(0L, userContext);
    }

    public Status unSubscribeTemplateTopic(TXDataTemplateConstants.TemplateSubTopic topicId) {
        return this.mDataTemplate.unSubscribeTemplateTopic(topicId);
    }

    public Status propertyReport(JSONObject property, JSONObject metadata) {
        return this.mDataTemplate.propertyReport(property, metadata);
    }

    public Status reportCallStatusProperty(Integer callStatus, Integer callType, String userId, String agent, JSONObject params) {
        return this.mDataTemplate.reportCallStatusProperty(callStatus, callType, userId, agent, params);
    }

    public Status reportResetCallStatusProperty() {
        return this.mDataTemplate.reportResetCallStatusProperty();
    }

    public Status propertyGetStatus(String type, boolean showmeta) {
        return this.mDataTemplate.propertyGetStatus(type, showmeta);
    }

    public Status propertyReportInfo(JSONObject params) {
        return this.mDataTemplate.propertyReportInfo(params);
    }

    public Status propertyClearControl() {
        return this.mDataTemplate.propertyClearControl();
    }

    public Status eventSinglePost(String eventId, String type, JSONObject params) {
        return this.mDataTemplate.eventSinglePost(eventId, type, params);
    }

    public Status eventsPost(JSONArray events) {
        return this.mDataTemplate.eventsPost(events);
    }

    public Status getUserAvatar(JSONArray userIdsArray) {
        return this.mDataTemplate.getUserAvatar(userIdsArray);
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        super.messageArrived(topic, message);
        this.mDataTemplate.onMessageArrived(topic, message);
    }

    public void connectComplete(boolean reconnect, String serverURI) {
        super.connectComplete(reconnect, serverURI);
    }
}

