/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.maven.parse.ast;

import com.qq.tars.maven.parse.ast.TarsType;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;

public class TarsPrimitiveType
extends TarsType {
    private final PrimitiveType primitiveType;

    public TarsPrimitiveType(Token token) {
        super(token, TarsPrimitiveType.toPrimitiveType(token.getType()).name());
        this.primitiveType = TarsPrimitiveType.toPrimitiveType(token.getType());
    }

    public TarsPrimitiveType(int type) {
        this((Token)new CommonToken(type));
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public TarsPrimitiveType asPrimitive() {
        return this;
    }

    public PrimitiveType primitiveType() {
        return this.primitiveType;
    }

    public boolean isVoid() {
        return this.primitiveType == PrimitiveType.VOID;
    }

    private static PrimitiveType toPrimitiveType(int tokenType) {
        PrimitiveType type = null;
        switch (tokenType) {
            case 50: {
                type = PrimitiveType.VOID;
                break;
            }
            case 22: {
                type = PrimitiveType.BOOL;
                break;
            }
            case 23: {
                type = PrimitiveType.BYTE;
                break;
            }
            case 43: {
                type = PrimitiveType.SHORT;
                break;
            }
            case 32: {
                type = PrimitiveType.INT;
                break;
            }
            case 36: {
                type = PrimitiveType.LONG;
                break;
            }
            case 28: {
                type = PrimitiveType.FLOAT;
                break;
            }
            case 25: {
                type = PrimitiveType.DOUBLE;
                break;
            }
            case 44: {
                type = PrimitiveType.STRING;
            }
        }
        return type;
    }

    public static enum PrimitiveType {
        VOID,
        BOOL,
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        STRING;

    }
}

