/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.maven.script;

import com.qq.tars.maven.model.ClasspathElement;
import com.qq.tars.maven.model.Dependency;
import com.qq.tars.maven.model.Directory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.util.StringUtils;

public class Platform {
    public static final String UNIX_NAME = "unix";
    public static final String WINDOWS_NAME = "windows";
    private static final Map<String, Platform> ALL_PLATFORMS = new HashMap<String, Platform>();
    private static final String DEFAULT_UNIX_BIN_FILE_EXTENSION = "";
    private static final String DEFAULT_WINDOWS_BIN_FILE_EXTENSION = ".bat";
    private String binFileExtension;
    private String name;
    private boolean isWindows;
    private boolean showConsoleWindow = true;

    private static Platform addPlatform(Platform platform) {
        ALL_PLATFORMS.put(platform.name, platform);
        return platform;
    }

    public static Platform getInstance(String platformName) throws Exception {
        Platform platform = ALL_PLATFORMS.get(platformName);
        if (platform == null) {
            throw new Exception("Unknown platform name '" + platformName + "'");
        }
        return platform;
    }

    public static Set<String> getAllPlatformNames() {
        return ALL_PLATFORMS.keySet();
    }

    public static Set<Platform> getAllPlatforms() {
        return new HashSet<Platform>(ALL_PLATFORMS.values());
    }

    public static Set<Platform> getPlatformSet(List<String> platformList) throws Exception {
        return Platform.getPlatformSet(platformList, new HashSet<Platform>(ALL_PLATFORMS.values()));
    }

    public static Set<Platform> getPlatformSet(List<String> platformList, Set<Platform> allSet) throws Exception {
        if (platformList == null) {
            return allSet;
        }
        if (platformList.size() == 1) {
            String first = platformList.get(0);
            if ("all".equals(first)) {
                return allSet;
            }
            throw new Exception("The special platform 'all' can only be used if it is the only element in the platform list.");
        }
        HashSet<Platform> platformSet = new HashSet<Platform>();
        for (String platformName : platformList) {
            if (platformName.equals("all")) {
                throw new Exception("The special platform 'all' can only be used if it is the only element in a platform list.");
            }
            platformSet.add(Platform.getInstance(platformName));
        }
        return platformSet;
    }

    private Platform(String name, boolean isWindows, String binFileExtension) {
        this.name = name;
        this.isWindows = isWindows;
        this.binFileExtension = binFileExtension;
    }

    public String getInterpolationToken() {
        return this.isWindows ? "#" : "@";
    }

    public String getBinFileExtension() {
        return this.binFileExtension;
    }

    public String getBasedir() {
        return this.isWindows ? "\"%BASEDIR%\"" : "\"$BASEDIR\"";
    }

    public String getRepo() {
        return this.isWindows ? "\"%REPO%\"" : "\"$REPO\"";
    }

    public String getSeparator() {
        return this.isWindows ? "\\" : "/";
    }

    public String getPathSeparator() {
        return this.isWindows ? ";" : ":";
    }

    public String getCommentPrefix() {
        return this.isWindows ? "@REM " : "# ";
    }

    public String getNewLine() {
        return this.isWindows ? "\r\n" : "\n";
    }

    public String getClassPath(List<? extends ClasspathElement> classpath) throws Exception {
        StringBuilder classpathBuffer = new StringBuilder();
        for (ClasspathElement classpathElement : classpath) {
            if (classpathBuffer.length() > 0) {
                classpathBuffer.append(this.getPathSeparator());
            }
            if (classpathElement instanceof Directory) {
                Directory directory = (Directory)classpathElement;
                if (directory.getRelativePath().charAt(0) != '/') {
                    classpathBuffer.append(this.getBasedir()).append(this.getSeparator());
                }
            } else if (classpathElement instanceof Dependency) {
                classpathBuffer.append(this.getSeparator());
            } else {
                throw new Exception("Unknown classpath element type: " + classpathElement.getClass().getName());
            }
            classpathBuffer.append(StringUtils.replace((String)classpathElement.getRelativePath(), (String)"/", (String)this.getSeparator()));
        }
        return classpathBuffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Platform platform = (Platform)o;
        return this.name.equals(platform.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public boolean isShowConsoleWindow() {
        return this.showConsoleWindow;
    }

    public void setBinFileExtension(String binFileExtension) {
        this.binFileExtension = binFileExtension == null ? DEFAULT_UNIX_BIN_FILE_EXTENSION : binFileExtension;
    }

    static {
        Platform.addPlatform(new Platform(UNIX_NAME, false, DEFAULT_UNIX_BIN_FILE_EXTENSION));
        Platform.addPlatform(new Platform(WINDOWS_NAME, true, DEFAULT_WINDOWS_BIN_FILE_EXTENSION));
    }
}

